/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.ShortFVComparison;
import org.openimaj.lsh.functions.ShortHashFunction;
import org.openimaj.lsh.functions.ShortHashFunctionFactory;
import org.openimaj.util.array.SparseShortArray;

@Reference(type=ReferenceType.Inproceedings, author={"Lv, Qin", "Charikar, Moses", "Li, Kai"}, title="Image similarity search with compact data structures", year="2004", booktitle="Proceedings of the thirteenth ACM international conference on Information and knowledge management", pages={"208", "", "217"}, url="http://doi.acm.org/10.1145/1031171.1031213", publisher="ACM", series="CIKM '04")
public class ShortHyperplaneL1Factory
extends ShortHashFunctionFactory {
    short min = 0;
    short max = 1;

    public ShortHyperplaneL1Factory(int ndims, MersenneTwister rng, short min, short max) {
        super(ndims, rng);
        this.min = min;
        this.max = max;
    }

    public Function create() {
        return new Function(this.ndims, this.rng);
    }

    @Override
    protected ShortFVComparison fvDistanceFunction() {
        return ShortFVComparison.CITY_BLOCK;
    }

    private class Function
    extends ShortHashFunction {
        int dimension;
        double shift;

        Function(int ndims, MersenneTwister rng) {
            super(rng);
            Uniform uniform = new Uniform((RandomEngine)rng);
            this.dimension = uniform.nextIntFromTo(0, ndims - 1);
            this.shift = uniform.nextDoubleFromTo((double)ShortHyperplaneL1Factory.this.min, (double)ShortHyperplaneL1Factory.this.max);
        }

        public int computeHashCode(short[] point) {
            return (double)point[this.dimension] - this.shift >= 0.0 ? 1 : 0;
        }

        @Override
        public int computeHashCode(SparseShortArray array) {
            return (double)array.get(this.dimension) - this.shift >= 0.0 ? 1 : 0;
        }
    }
}

