/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.composition;

import java.util.List;
import org.openimaj.util.hash.HashFunction;
import org.openimaj.util.hash.HashFunctionFactory;
import org.openimaj.util.hash.composition.HashComposition;

public class PolyHashComposition<OBJECT>
extends HashComposition<OBJECT> {
    private static final int HASH_POLY = 1368547;
    private static final int HASH_POLY_REM = 573440;
    private static final int[] HASH_POLY_A = new int[]{1342, 876454, 656565, 223, 337, 9847, 87676, 34234, 23445, 76543, 8676234, 3497, 9876, 87856, 2342858};

    public PolyHashComposition(List<HashFunction<OBJECT>> functions) {
        super(functions);
    }

    @SafeVarargs
    public PolyHashComposition(HashFunction<OBJECT> first, HashFunction<OBJECT> ... remainder) {
        super(first, remainder);
    }

    public PolyHashComposition(HashFunctionFactory<OBJECT> factory, int nFuncs) {
        super(factory, nFuncs);
    }

    private final int addId(int id, int val, int pos) {
        return val * HASH_POLY_A[pos % HASH_POLY_A.length] % 1368547 + id * 573440 % 1368547;
    }

    public int computeHashCode(OBJECT object) {
        if (this.hashFunctions == null || this.hashFunctions.size() == 0) {
            return 0;
        }
        int id = ((HashFunction)this.hashFunctions.get(0)).computeHashCode(object);
        int s = this.hashFunctions.size();
        for (int i = 1; i < s; ++i) {
            int val = ((HashFunction)this.hashFunctions.get(i)).computeHashCode(object);
            id = this.addId(id, val, i);
        }
        return id;
    }
}

