/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn;

import org.openimaj.feature.DoubleFVComparator;
import org.openimaj.knn.NearestNeighbours;
import org.openimaj.util.pair.IntDoublePair;

public abstract class DoubleNearestNeighbours
implements NearestNeighbours<double[], double[], IntDoublePair> {
    public static void distanceFunc(double[] qu, double[][] pnts, double[] dsq_out) {
        int N = pnts.length;
        int D = pnts[0].length;
        for (int n = 0; n < N; ++n) {
            dsq_out[n] = 0.0;
            for (int d = 0; d < D; ++d) {
                int n2 = n;
                dsq_out[n2] = dsq_out[n2] + (qu[d] - pnts[n][d]) * (qu[d] - pnts[n][d]);
            }
        }
    }

    public static double distanceFunc(double[] qu, double[] pnt) {
        int D = pnt.length;
        double dsq_out = 0.0;
        for (int d = 0; d < D; ++d) {
            dsq_out += (qu[d] - pnt[d]) * (qu[d] - pnt[d]);
        }
        return dsq_out;
    }

    public static double distanceFunc(DoubleFVComparator distance, double[] qu, double[] pnt) {
        if (distance == null) {
            return DoubleNearestNeighbours.distanceFunc(qu, pnt);
        }
        if (distance.isDistance()) {
            return distance.compare(qu, pnt);
        }
        return -distance.compare(qu, pnt);
    }

    public static void distanceFunc(DoubleFVComparator distance, double[] qu, double[][] pnts, double[] dsq_out) {
        if (distance == null) {
            DoubleNearestNeighbours.distanceFunc(qu, pnts, dsq_out);
            return;
        }
        int N = pnts.length;
        if (distance.isDistance()) {
            for (int n = 0; n < N; ++n) {
                dsq_out[n] = distance.compare(qu, pnts[n]);
            }
        } else {
            for (int n = 0; n < N; ++n) {
                dsq_out[n] = -distance.compare(qu, pnts[n]);
            }
        }
    }

    public abstract int numDimensions();
}

