/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import org.openimaj.image.pixel.Pixel;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Circle;
import org.openimaj.math.geometry.shape.Shape;

public class Quad {
    public float[] xs = new float[4];
    public float[] ys = new float[4];
    public float vertexRadius = 8.0f;
    public static int INTERIOR = 5;
    public Integer selected;
    public static float DEFAULT_PAD = 10.0f;
    public static float DEFAULT_WIDTH = 100.0f;
    public static float DEFAULT_HEIGHT = 100.0f;

    public Quad() {
        this.xs[0] = DEFAULT_PAD;
        this.xs[1] = DEFAULT_PAD + DEFAULT_WIDTH;
        this.xs[2] = this.xs[1];
        this.xs[3] = this.xs[0];
        this.ys[0] = DEFAULT_PAD;
        this.ys[1] = DEFAULT_PAD;
        this.ys[2] = DEFAULT_PAD + DEFAULT_HEIGHT;
        this.ys[3] = this.ys[2];
    }

    public Pixel getXY(float u, float v) {
        float xA = this.xs[0] + (this.xs[1] - this.xs[0]) * u;
        float xB = this.xs[3] + (this.xs[2] - this.xs[3]) * u;
        float yC = this.ys[0] + (this.ys[3] - this.ys[0]) * v;
        float yD = this.ys[1] + (this.ys[2] - this.ys[1]) * v;
        float yA = this.ys[0] + (this.ys[1] - this.ys[0]) * u;
        float yB = this.ys[3] + (this.ys[2] - this.ys[3]) * u;
        float xC = this.xs[0] + (this.xs[3] - this.xs[0]) * v;
        float xD = this.xs[1] + (this.xs[2] - this.xs[1]) * v;
        float denom = (xA - xB) * (yC - yD) - (yA - yB) * (xC - xD);
        if (denom == 0.0f) {
            return new Pixel(0, 0);
        }
        float px = ((xA * yB - yA * xB) * (xC - xD) - (xA - xB) * (xC * yD - yC * xD)) / denom;
        float py = ((xA * yB - yA * xB) * (yC - yD) - (yA - yB) * (xC * yD - yC * xD)) / denom;
        return new Pixel((int)px, (int)py);
    }

    public Shape getVertexShape(int k) {
        return new Circle(this.xs[k], this.ys[k], this.vertexRadius);
    }

    public boolean isInside(int x, int y) {
        double wind = 0.0;
        int k = 0;
        while (k < 4) {
            wind += this.subtend(x, y, this.xs[k], this.ys[k], this.xs[(k + 1) % 4], this.ys[(k + 1) % 4]);
            ++k;
        }
        return !(wind > -0.01) || !(wind < 0.01);
    }

    public double subtend(float xo, float yo, float xa, float ya, float xb, float yb) {
        double ta;
        double tb = Math.atan2(yb - yo, xb - xo);
        double diff = (Math.PI * 4 + tb - (ta = Math.atan2(ya - yo, xa - xo))) % (Math.PI * 2);
        if (diff <= Math.PI) {
            return diff;
        }
        return diff - Math.PI * 2;
    }

    public boolean isSelected(int x, int y, int vertex) {
        return this.getVertexShape(vertex).isInside((Point2d)new Pixel(x, y));
    }

    public void updateSelected(int x, int y) {
        this.selected = null;
        int k = 0;
        while (k < 4) {
            if (this.isSelected(x, y, k)) {
                this.selected = k;
            }
            ++k;
        }
        if (this.selected == null && this.isInside(x, y)) {
            this.selected = INTERIOR;
        }
    }

    public void moveSelectedBy(int dx, int dy) {
        if (this.selected == null) {
            return;
        }
        if (this.selected == INTERIOR) {
            int k = 0;
            while (k < 4) {
                int n = k;
                this.xs[n] = this.xs[n] + (float)dx;
                int n2 = k++;
                this.ys[n2] = this.ys[n2] + (float)dy;
            }
        } else {
            int n = this.selected;
            this.xs[n] = this.xs[n] + (float)dx;
            int n3 = this.selected;
            this.ys[n3] = this.ys[n3] + (float)dy;
        }
    }

    public void boundWithin(int width, int height) {
        int k = 0;
        while (k < 4) {
            this.xs[k] = Math.min(Math.max(this.xs[k], 0.0f), (float)(width - 1));
            this.ys[k] = Math.min(Math.max(0.0f, this.ys[k]), (float)(height - 1));
            ++k;
        }
    }
}

