/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import com.salelder.App;
import com.salelder.PreviewMouse;
import com.salelder.Quad;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.colour.Transforms;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.edges.CannyEdgeDetector;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplay;
import org.openimaj.video.VideoDisplayListener;
import org.openimaj.video.capture.Device;
import org.openimaj.video.capture.VideoCapture;

public class PreviewPanel
extends JPanel {
    public static int VIDEO_WIDTH = 640;
    public static int VIDEO_HEIGHT = 480;
    private static Float[] LINECOLOR = RGBColour.GREEN;
    private static Float[] ACTIVECOLOR = RGBColour.RED;
    private CannyEdgeDetector cannyEdgeDetector;
    public Quad quad;
    private Video<MBFImage> video;
    private VideoDisplay<MBFImage> display;
    private File referenceFile;
    private MBFImage reference;
    private MBFImage referenceOriginalSize;
    private float opacity = 0.5f;
    public float brightness = 1.0f;
    public float contrast = 1.0f;
    public float scale = 1.0f;
    public float panX = 0.0f;
    public float panY = 0.0f;
    public double colorTemp = 6500.0;
    private double[] tempRGB = new double[]{1.0, 1.0, 1.0};
    private boolean distortCam = false;
    private boolean edgeDetect = false;
    private PreviewMouse mouse;
    private App app;

    public PreviewPanel(App a) {
        this.app = a;
        this.quad = new Quad();
        this.mouse = new PreviewMouse(this);
        this.setWebcam(null);
        this.cannyEdgeDetector = new CannyEdgeDetector();
    }

    public int getVideoWidth() {
        if (this.video == null) {
            return VIDEO_WIDTH;
        }
        return this.video.getWidth();
    }

    public int getVideoHeight() {
        if (this.video == null) {
            return VIDEO_HEIGHT;
        }
        return this.video.getHeight();
    }

    public void setReference(File f) throws IOException {
        if (f == null) {
            this.referenceFile = null;
            this.reference = null;
            return;
        }
        MBFImage ref = ImageUtilities.readMBF((File)f);
        this.referenceFile = f;
        this.setReferenceImage(ref);
    }

    public void setReferenceImageWithoutFile(MBFImage img) {
        this.referenceFile = null;
        this.setReferenceImage(img);
    }

    public File getReferenceFile() {
        return this.referenceFile;
    }

    public void setWebcam(Device d) {
        this.setWebcam(d, VIDEO_WIDTH, VIDEO_HEIGHT);
    }

    public void setVideoSize(int width, int height) {
        this.setWebcam(null, width, height);
    }

    public void setWebcam(Device d, int video_width, int video_height) {
        if (this.video != null) {
            this.video.close();
            this.display.close();
            this.remove((Component)this.display.getScreen());
        }
        try {
            if (d == null) {
                d = (Device)VideoCapture.getVideoDevices().get(0);
            }
            this.video = new VideoCapture(video_width, video_height, d);
            this.resizeReferenceImage();
            this.quad.boundWithin(this.video.getWidth(), this.video.getHeight());
            this.display = VideoDisplay.createVideoDisplay(this.video, (JComponent)this);
            this.display.addVideoListener((VideoDisplayListener)new VideoDisplayListener<MBFImage>(){

                public void beforeUpdate(MBFImage frame) {
                    PreviewPanel.this.adjustFrameColor(frame);
                    if (PreviewPanel.this.reference != null && !PreviewPanel.this.distortCam) {
                        PreviewPanel.this.drawReference(frame);
                        PreviewPanel.this.drawQuad(frame);
                    } else if (PreviewPanel.this.reference != null && PreviewPanel.this.distortCam) {
                        MBFImage clone = (MBFImage)frame.clone();
                        frame.fill(RGBColour.BLACK);
                        MBFImage reference = PreviewPanel.this.reference;
                        if (PreviewPanel.this.edgeDetect) {
                            reference = (MBFImage)PreviewPanel.this.reference.clone();
                            PreviewPanel.this.drawEdges(reference, RGBColour.RED);
                        }
                        frame.drawImage((Image)reference, 0, 0);
                        PreviewPanel.this.drawSelectedRegion(frame, clone);
                    }
                    PreviewPanel.this.transformFrame(frame);
                }

                public void afterUpdate(VideoDisplay<MBFImage> display) {
                }
            });
            this.display.getScreen().addMouseListener((MouseListener)this.mouse);
            this.display.getScreen().addMouseMotionListener((MouseMotionListener)this.mouse);
            this.app.setStatus("Started webcam.");
            this.app.revalidate();
            this.app.repaint();
        }
        catch (Exception e) {
            this.app.setStatus("Error: Couldn't start webcam.");
            e.printStackTrace();
        }
    }

    private void setReferenceImage(MBFImage reference) {
        this.referenceOriginalSize = (MBFImage)reference.clone();
        this.reference = reference;
        float scale = Math.min(1.0f * (float)this.video.getHeight() / (float)reference.getHeight(), 1.0f * (float)this.video.getWidth() / (float)reference.getWidth());
        this.reference = (MBFImage)reference.process((SinglebandImageProcessor)new ResizeProcessor(scale));
    }

    private void resizeReferenceImage() {
        if (this.referenceOriginalSize == null) {
            return;
        }
        this.setReferenceImage(this.referenceOriginalSize);
    }

    public void setOpacity(float o) {
        this.opacity = o;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public boolean hasReference() {
        return this.referenceFile != null;
    }

    public void toggleView() {
        if (this.reference == null) {
            return;
        }
        this.distortCam = !this.distortCam;
    }

    private void drawQuad(MBFImage frame) {
        int k = 0;
        while (k < 4) {
            Shape s = this.quad.getVertexShape(k);
            Float[] vColor = LINECOLOR;
            Float[] lColor = LINECOLOR;
            if (this.quad.selected != null && this.quad.selected == k) {
                vColor = ACTIVECOLOR;
            }
            frame.drawShape(s, (Object)vColor);
            if (this.quad.selected != null && this.quad.selected == Quad.INTERIOR) {
                lColor = ACTIVECOLOR;
            }
            frame.drawLine((int)this.quad.xs[k], (int)this.quad.ys[k], (int)this.quad.xs[(k + 1) % 4], (int)this.quad.ys[(k + 1) % 4], (Object)lColor);
            ++k;
        }
    }

    private void drawReference(MBFImage frame) {
        MBFImage clone = (MBFImage)frame.clone();
        MBFImage reference = (MBFImage)this.reference.clone();
        if (this.edgeDetect) {
            this.drawEdges(reference, RGBColour.RED);
        }
        int row = 0;
        while (row < reference.getHeight()) {
            int col = 0;
            while (col < reference.getWidth()) {
                float u = 1.0f * (float)col / (float)reference.getWidth();
                float v = 1.0f * (float)row / (float)reference.getHeight();
                Pixel destination = this.quad.getXY(u, v);
                this.boundWithin(destination, frame);
                Float[] camColor = this.getPixel(clone, destination);
                Float[] refColor = this.getPixel(reference, col, row);
                Float[] mixColor = this.mixColor(camColor, refColor, this.opacity);
                if (this.edgeDetect) {
                    mixColor = this.addColor(camColor, refColor);
                }
                frame.drawPoint((Point2d)destination, (Object)mixColor, 1);
                ++col;
            }
            ++row;
        }
    }

    public void updateSelected(int x, int y) {
        int width = VIDEO_WIDTH;
        int height = VIDEO_HEIGHT;
        if (this.video != null) {
            width = this.video.getWidth();
            height = this.video.getHeight();
        }
        Pixel old_loc = this.transformedToUntransformedCoordinates(width, height, x, y);
        if (this.quad != null) {
            this.quad.updateSelected(old_loc.x, old_loc.y);
        }
    }

    private Pixel transformedToUntransformedCoordinates(int width, int height, int x, int y) {
        int old_row = (int)((double)(0.5f * (float)height) + (double)(1.0f / this.scale) * ((double)y - (double)height * (0.5 - (double)this.panY)));
        int old_col = (int)((double)(0.5f * (float)width) + (double)(1.0f / this.scale) * ((double)x - (double)width * (0.5 + (double)this.panX)));
        return new Pixel(old_col, old_row);
    }

    private void transformFrame(MBFImage frame) {
        MBFImage original = (MBFImage)frame.clone();
        int r = 0;
        while (r < original.getRows()) {
            int c = 0;
            while (c < original.getCols()) {
                Pixel old_loc = this.transformedToUntransformedCoordinates(original.getCols(), original.getRows(), c, r);
                Float[] color = this.getPixel(original, old_loc.x, old_loc.y);
                frame.drawPoint((Point2d)new Pixel(c, r), (Object)color, 1);
                ++c;
            }
            ++r;
        }
        if (this.edgeDetect) {
            this.drawEdges(frame, RGBColour.BLUE);
        }
    }

    private void adjustFrameColor(MBFImage frame) {
        MBFImage original = (MBFImage)frame.clone();
        int r = 0;
        while (r < original.getRows()) {
            int c = 0;
            while (c < original.getCols()) {
                Float[] color = this.getPixel(original, c, r);
                int band = 0;
                while (band < 3) {
                    int n = band;
                    color[n] = Float.valueOf(color[n].floatValue() / (float)this.tempRGB[band]);
                    color[band] = Float.valueOf(this.sigmoid(color[band].floatValue(), this.contrast));
                    int n2 = band;
                    color[n2] = Float.valueOf(color[n2].floatValue() * this.brightness);
                    color[band] = Float.valueOf(Math.min(1.0f, color[band].floatValue()));
                    ++band;
                }
                frame.drawPoint((Point2d)new Pixel(c, r), (Object)color, 1);
                ++c;
            }
            ++r;
        }
    }

    private void drawEdges(MBFImage frame, Float[] color) {
        frame.processInplace((SinglebandImageProcessor)this.cannyEdgeDetector);
        int r = 0;
        while (r < frame.getHeight()) {
            int c = 0;
            while (c < frame.getWidth()) {
                Float[] col = frame.getPixel(c, r);
                if ((double)col[0].floatValue() > 0.5 && (double)col[1].floatValue() > 0.5 && (double)col[2].floatValue() > 0.5) {
                    frame.setPixel(c, r, color);
                } else {
                    frame.setPixel(c, r, RGBColour.BLACK);
                }
                ++c;
            }
            ++r;
        }
    }

    private float sigmoid(float x, float p) {
        if ((double)x <= 0.5) {
            return (float)(Math.pow(x, p) * Math.pow(0.5, 1.0f - p));
        }
        return 1.0f - this.sigmoid(1.0f - x, p);
    }

    private Float[] getPixel(MBFImage im, int x, int y) {
        if (x < im.getCols() && x >= 0 && y < im.getRows() && y >= 0) {
            return im.getPixel(x, y);
        }
        return RGBColour.BLACK;
    }

    private Float[] getPixel(MBFImage im, Pixel p) {
        return this.getPixel(im, (int)p.getX(), (int)p.getY());
    }

    private void drawSelectedRegion(MBFImage frame, MBFImage image) {
        MBFImage reference = (MBFImage)this.reference.clone();
        int row = 0;
        while (row < reference.getHeight()) {
            int col = 0;
            while (col < reference.getWidth()) {
                Pixel quadLocation = this.quad.getXY(1.0f * (float)col / (float)reference.getWidth(), 1.0f * (float)row / (float)reference.getHeight());
                Float[] refColor = this.getPixel(frame, col, row);
                Float[] camColor = this.getPixel(image, quadLocation);
                Float[] newColor = this.mixColor(camColor, refColor, this.opacity);
                if (this.edgeDetect) {
                    newColor = this.addColor(camColor, refColor);
                }
                frame.drawPoint((Point2d)new Pixel(col, row), (Object)newColor, 1);
                ++col;
            }
            ++row;
        }
    }

    private Float[] mixColor(Float[] color1, Float[] color2, float opacity) {
        Float[] res = new Float[3];
        int k = 0;
        while (k < 3) {
            res[k] = Float.valueOf((1.0f - opacity) * color1[k].floatValue() + opacity * color2[k].floatValue());
            ++k;
        }
        return res;
    }

    private Float[] addColor(Float[] color1, Float[] color2) {
        Float[] res = new Float[3];
        int k = 0;
        while (k < 3) {
            res[k] = Float.valueOf(Math.min(1.0f, color1[k].floatValue() + color2[k].floatValue()));
            ++k;
        }
        return res;
    }

    private void boundWithin(Pixel px, MBFImage img) {
        if (px.getX() >= (float)(img.getWidth() - 1)) {
            px.setX((float)(img.getWidth() - 1));
        }
        if (px.getX() < 0.0f) {
            px.setX(0.0f);
        }
        if (px.getY() >= (float)(img.getHeight() - 1)) {
            px.setY((float)(img.getHeight() - 1));
        }
        if (px.getY() < 0.0f) {
            px.setY(0.0f);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(VIDEO_WIDTH, VIDEO_HEIGHT);
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public void setContrast(float contrast) {
        this.contrast = contrast;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setPanX(float panX) {
        this.panX = panX;
    }

    public void setPanY(float panY) {
        this.panY = panY;
    }

    public void setColorTemp(double temp) {
        this.colorTemp = temp;
        this.tempRGB = Transforms.kelvinToRGB((double)temp);
    }

    public void toggleEdges() {
        this.edgeDetect = !this.edgeDetect;
    }
}

