/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget.vhs;

import com.github.axet.vget.info.VGetParser;
import com.github.axet.vget.info.VideoInfo;
import com.github.axet.wget.WGet;
import com.github.axet.wget.info.ex.DownloadError;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class YouTubeParser
extends VGetParser {
    static final String UTF8 = "UTF-8";
    URL source;
    static final Map<Integer, VideoInfo.VideoQuality> itagMap = new HashMap<Integer, VideoInfo.VideoQuality>(){
        private static final long serialVersionUID = -6925194111122038477L;
        {
            this.put(120, VideoInfo.VideoQuality.p720);
            this.put(102, VideoInfo.VideoQuality.p720);
            this.put(101, VideoInfo.VideoQuality.p360);
            this.put(100, VideoInfo.VideoQuality.p360);
            this.put(85, VideoInfo.VideoQuality.p520);
            this.put(84, VideoInfo.VideoQuality.p720);
            this.put(83, VideoInfo.VideoQuality.p240);
            this.put(82, VideoInfo.VideoQuality.p360);
            this.put(46, VideoInfo.VideoQuality.p1080);
            this.put(45, VideoInfo.VideoQuality.p720);
            this.put(44, VideoInfo.VideoQuality.p480);
            this.put(43, VideoInfo.VideoQuality.p360);
            this.put(38, VideoInfo.VideoQuality.p3072);
            this.put(37, VideoInfo.VideoQuality.p1080);
            this.put(36, VideoInfo.VideoQuality.p240);
            this.put(35, VideoInfo.VideoQuality.p480);
            this.put(34, VideoInfo.VideoQuality.p360);
            this.put(22, VideoInfo.VideoQuality.p720);
            this.put(18, VideoInfo.VideoQuality.p360);
            this.put(17, VideoInfo.VideoQuality.p144);
            this.put(6, VideoInfo.VideoQuality.p270);
            this.put(5, VideoInfo.VideoQuality.p240);
        }
    };

    public YouTubeParser(URL input) {
        this.source = input;
    }

    public static boolean probe(URL url) {
        return url.toString().contains("youtube.com");
    }

    @Override
    public List<VGetParser.VideoDownload> extract(VideoInfo info, AtomicBoolean stop, Runnable notify) {
        try {
            try {
                return this.extractEmbedded(info, stop, notify);
            }
            catch (EmbeddingDisabled e) {
                return this.streamCpature(info, stop, notify);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    List<VGetParser.VideoDownload> streamCpature(final VideoInfo info, AtomicBoolean stop, final Runnable notify) throws Exception {
        ArrayList<VGetParser.VideoDownload> sNextVideoURL = new ArrayList<VGetParser.VideoDownload>();
        String html = WGet.getHtml((URL)info.getWeb(), (WGet.HtmlLoader)new WGet.HtmlLoader(){

            public void notifyRetry(int delay, Throwable e) {
                info.setDelay(delay, e);
                notify.run();
            }

            public void notifyDownloading() {
                info.setState(VideoInfo.States.DOWNLOADING);
                notify.run();
            }

            public void notifyMoved() {
                info.setState(VideoInfo.States.RETRYING);
                notify.run();
            }
        }, (AtomicBoolean)stop);
        this.extractHtmlInfo(sNextVideoURL, info, html, stop, notify);
        this.extractIcon(info, html);
        return sNextVideoURL;
    }

    void addVideo(List<VGetParser.VideoDownload> sNextVideoURL, String itag, URL url) {
        Integer i = Integer.decode(itag);
        VideoInfo.VideoQuality vd = itagMap.get(i);
        sNextVideoURL.add(new VGetParser.VideoDownload(vd, url));
    }

    public static String extractId(URL url) {
        Pattern u = Pattern.compile("youtube.com/watch?.*v=([^&]*)");
        Matcher um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        u = Pattern.compile("youtube.com/v/([^&]*)");
        um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        return null;
    }

    List<VGetParser.VideoDownload> extractEmbedded(final VideoInfo info, AtomicBoolean stop, final Runnable notify) throws Exception {
        ArrayList<VGetParser.VideoDownload> sNextVideoURL = new ArrayList<VGetParser.VideoDownload>();
        String id = YouTubeParser.extractId(this.source);
        if (id == null) {
            throw new RuntimeException("unknown url");
        }
        info.setTitle(String.format("http://www.youtube.com/watch?v=%s", id));
        String get = String.format("http://www.youtube.com/get_video_info?authuser=0&video_id=%s&el=embedded", id);
        URL url = new URL(get);
        String qs = WGet.getHtml((URL)url, (WGet.HtmlLoader)new WGet.HtmlLoader(){

            public void notifyRetry(int delay, Throwable e) {
                info.setDelay(delay, e);
                notify.run();
            }

            public void notifyDownloading() {
                info.setState(VideoInfo.States.DOWNLOADING);
                notify.run();
            }

            public void notifyMoved() {
                info.setState(VideoInfo.States.RETRYING);
                notify.run();
            }
        }, (AtomicBoolean)stop);
        Map<String, String> map = YouTubeParser.getQueryMap(qs);
        if (map.get("status").equals("fail")) {
            String r = URLDecoder.decode(map.get("reason"), UTF8);
            if (map.get("errorcode").equals("150")) {
                throw new EmbeddingDisabled("error code 150");
            }
            if (map.get("errorcode").equals("100")) {
                throw new VideoDeleted("error code 100");
            }
            throw new DownloadError(r);
        }
        info.setTitle(URLDecoder.decode(map.get("title"), UTF8));
        String url_encoded_fmt_stream_map = URLDecoder.decode(map.get("url_encoded_fmt_stream_map"), UTF8);
        this.extractUrlEncodedVideos(sNextVideoURL, url_encoded_fmt_stream_map);
        String icon = map.get("thumbnail_url");
        icon = URLDecoder.decode(icon, UTF8);
        info.setIcon(new URL(icon));
        return sNextVideoURL;
    }

    void extractIcon(VideoInfo info, String html) {
        try {
            Pattern title = Pattern.compile("itemprop=\"thumbnailUrl\" href=\"(.*)\"");
            Matcher titleMatch = title.matcher(html);
            if (titleMatch.find()) {
                String sline = titleMatch.group(1);
                sline = StringEscapeUtils.unescapeHtml4((String)sline);
                info.setIcon(new URL(sline));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getQueryMap(String qs) {
        try {
            qs = qs.trim();
            List list = URLEncodedUtils.parse((URI)new URI(null, null, null, -1, null, qs, null), (String)UTF8);
            HashMap<String, String> map = new HashMap<String, String>();
            for (NameValuePair p : list) {
                map.put(p.getName(), p.getValue());
            }
            return map;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(qs, e);
        }
    }

    void extractHtmlInfo(List<VGetParser.VideoDownload> sNextVideoURL, VideoInfo info, String html, AtomicBoolean stop, Runnable notify) throws Exception {
        Pattern title;
        Matcher titleMatch;
        Pattern age = Pattern.compile("(verify_age)");
        Matcher ageMatch = age.matcher(html);
        if (ageMatch.find()) {
            throw new AgeException();
        }
        age = Pattern.compile("(unavailable-player)");
        ageMatch = age.matcher(html);
        if (ageMatch.find()) {
            throw new VideoUnavailablePlayer();
        }
        Pattern urlencod = Pattern.compile("\"url_encoded_fmt_stream_map\": \"([^\"]*)\"");
        Matcher urlencodMatch = urlencod.matcher(html);
        if (urlencodMatch.find()) {
            Pattern encodStream;
            Matcher encodStreamMatch;
            String url_encoded_fmt_stream_map = urlencodMatch.group(1);
            Pattern encod = Pattern.compile("url=(.*)");
            Matcher encodMatch = encod.matcher(url_encoded_fmt_stream_map);
            if (encodMatch.find()) {
                String sline = encodMatch.group(1);
                this.extractUrlEncodedVideos(sNextVideoURL, sline);
            }
            if ((encodStreamMatch = (encodStream = Pattern.compile("stream=(.*)")).matcher(url_encoded_fmt_stream_map)).find()) {
                String[] urlStrings;
                String sline = encodStreamMatch.group(1);
                for (String urlString : urlStrings = sline.split("stream=")) {
                    urlString = StringEscapeUtils.unescapeJava((String)urlString);
                    Pattern link = Pattern.compile("(sparams.*)&itag=(\\d+)&.*&conn=rtmpe(.*),");
                    Matcher linkMatch = link.matcher(urlString);
                    if (!linkMatch.find()) continue;
                    String sparams = linkMatch.group(1);
                    String itag = linkMatch.group(2);
                    String url = linkMatch.group(3);
                    url = "http" + url + "?" + sparams;
                    url = URLDecoder.decode(url, UTF8);
                    this.addVideo(sNextVideoURL, itag, new URL(url));
                }
            }
        }
        if ((titleMatch = (title = Pattern.compile("<meta name=\"title\" content=(.*)")).matcher(html)).find()) {
            String sline = titleMatch.group(1);
            String name = sline.replaceFirst("<meta name=\"title\" content=", "").trim();
            name = StringUtils.strip((String)name, (String)"\">");
            name = StringEscapeUtils.unescapeHtml4((String)name);
            info.setTitle(name);
        }
    }

    void extractUrlEncodedVideos(List<VGetParser.VideoDownload> sNextVideoURL, String sline) throws Exception {
        String[] urlStrings;
        for (String urlString : urlStrings = sline.split("url=")) {
            Pattern link;
            Matcher linkMatch;
            String sig;
            urlString = StringEscapeUtils.unescapeJava((String)urlString);
            String urlFull = URLDecoder.decode(urlString, UTF8);
            String url = null;
            Pattern link2 = Pattern.compile("([^&,]*)[&,]");
            Matcher linkMatch2 = link2.matcher(urlString);
            if (linkMatch2.find()) {
                url = linkMatch2.group(1);
                url = URLDecoder.decode(url, UTF8);
            }
            String itag = null;
            Pattern link3 = Pattern.compile("itag=(\\d+)");
            Matcher linkMatch3 = link3.matcher(urlFull);
            if (linkMatch3.find()) {
                itag = linkMatch3.group(1);
            }
            if ((sig = null) == null && (linkMatch = (link = Pattern.compile("&signature=([^&,]*)")).matcher(urlFull)).find()) {
                sig = linkMatch.group(1);
            }
            if (sig == null && (linkMatch = (link = Pattern.compile("sig=([^&,]*)")).matcher(urlFull)).find()) {
                sig = linkMatch.group(1);
            }
            if (sig == null && (linkMatch = (link = Pattern.compile("[&,]s=([^&,]*)")).matcher(urlFull)).find()) {
                sig = linkMatch.group(1);
            }
            System.err.println(urlString);
            if (url == null || itag == null || sig == null) continue;
            try {
                url = url + "&signature=" + sig;
                this.addVideo(sNextVideoURL, itag, new URL(url));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    public static class VideoDeleted
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public VideoDeleted(String msg) {
            super(msg);
        }
    }

    public static class EmbeddingDisabled
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public EmbeddingDisabled(String msg) {
            super(msg);
        }
    }

    public static class PrivateVideoException
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public PrivateVideoException() {
            super("Private video");
        }

        public PrivateVideoException(String s) {
            super(s);
        }
    }

    public static class AgeException
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public AgeException() {
            super("Age restriction, account required");
        }
    }

    public static class VideoUnavailablePlayer
    extends DownloadError {
        private static final long serialVersionUID = 10905065542230199L;

        public VideoUnavailablePlayer() {
            super("unavailable-player");
        }
    }
}

