/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget.vhs;

import com.github.axet.vget.info.VGetParser;
import com.github.axet.vget.info.VideoInfo;
import com.github.axet.wget.WGet;
import com.github.axet.wget.info.ex.DownloadError;
import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class VimeoParser
extends VGetParser {
    URL source;

    public VimeoParser(URL input) {
        this.source = input;
    }

    public static boolean probe(URL url) {
        return url.toString().contains("vimeo.com");
    }

    public static String extractId(URL url) {
        Pattern u = Pattern.compile("vimeo.com.*/(\\d+)");
        Matcher um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        u = Pattern.compile("vimeo.com.*=(\\d+)");
        um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        return null;
    }

    @Override
    public List<VGetParser.VideoDownload> extract(final VideoInfo info, AtomicBoolean stop, final Runnable notify) {
        ArrayList<VGetParser.VideoDownload> list = new ArrayList<VGetParser.VideoDownload>();
        try {
            String id = VimeoParser.extractId(info.getWeb());
            if (id == null) {
                throw new DownloadError("unknown url");
            }
            String clip = "http://vimeo.com/m/" + id;
            URL url = new URL(clip);
            String html = WGet.getHtml((URL)url, (WGet.HtmlLoader)new WGet.HtmlLoader(){

                public void notifyRetry(int delay, Throwable e) {
                    info.setDelay(delay, e);
                    notify.run();
                }

                public void notifyDownloading() {
                    info.setState(VideoInfo.States.EXTRACTING);
                    notify.run();
                }

                public void notifyMoved() {
                    info.setState(VideoInfo.States.RETRYING);
                    notify.run();
                }
            }, (AtomicBoolean)stop);
            Pattern u = Pattern.compile("data-config-url=\"([^\"]+)\"");
            Matcher um = u.matcher(html);
            if (!um.find()) {
                throw new DownloadError("unknown config vimeo respond");
            }
            String config = um.group(1);
            config = StringEscapeUtils.unescapeHtml4((String)config);
            String htmlConfig = WGet.getHtml((URL)new URL(config), (WGet.HtmlLoader)new WGet.HtmlLoader(){

                public void notifyRetry(int delay, Throwable e) {
                    info.setDelay(delay, e);
                    notify.run();
                }

                public void notifyDownloading() {
                    info.setState(VideoInfo.States.EXTRACTING);
                    notify.run();
                }

                public void notifyMoved() {
                    info.setState(VideoInfo.States.RETRYING);
                    notify.run();
                }
            }, (AtomicBoolean)stop);
            VimeoData data = (VimeoData)new Gson().fromJson(htmlConfig, VimeoData.class);
            String icon = data.video.thumbs.values().iterator().next();
            info.setTitle(data.video.title);
            list.add(new VGetParser.VideoDownload(VideoInfo.VideoQuality.p1080, new URL(data.request.files.h264.hd.url)));
            list.add(new VGetParser.VideoDownload(VideoInfo.VideoQuality.p480, new URL(data.request.files.h264.sd.url)));
            info.setIcon(new URL(icon));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public static class VidemoCodec {
        public VideoDownloadLink hd;
        public VideoDownloadLink sd;
        public VideoDownloadLink mobile;
    }

    public static class VideoDownloadLink {
        public String url;
        public int height;
        public int width;
        public String id;
        public int bitrate;
    }

    public static class VimeoData {
        public VimeoRequest request;
        public VimeoVideo video;
    }

    public static class VimeoFiles {
        public ArrayList<String> codecs;
        public VidemoCodec h264;
    }

    public static class VimeoRequest {
        public String signature;
        public String session;
        public long timestamp;
        public long expires;
        public VimeoFiles files;
    }

    public static class VimeoVideo {
        public Map<String, String> thumbs;
        public String title;
    }
}

