/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget.info;

import com.github.axet.vget.info.VGetParser;
import com.github.axet.vget.info.VideoInfoUser;
import com.github.axet.vget.vhs.VimeoParser;
import com.github.axet.vget.vhs.YouTubeParser;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.ex.DownloadError;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoInfo {
    private URL web;
    private List<VGetParser.VideoDownload> videoDownloads;
    private VideoQuality vq;
    private DownloadInfo info;
    private String title;
    private URL icon;
    private States state;
    private Throwable exception;
    private int delay;

    public VideoInfo(URL web) {
        this.setWeb(web);
        this.reset();
    }

    public boolean empty() {
        return this.info == null;
    }

    public void reset() {
        this.setState(States.QUEUE);
        this.info = null;
        this.vq = null;
        this.title = null;
        this.icon = null;
        this.exception = null;
        this.delay = 0;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DownloadInfo getInfo() {
        return this.info;
    }

    public void setInfo(DownloadInfo info) {
        this.info = info;
    }

    public VideoQuality getVideoQuality() {
        return this.vq;
    }

    public void setVideoQuality(VideoQuality vq) {
        this.vq = vq;
    }

    public URL getWeb() {
        return this.web;
    }

    public void setWeb(URL source) {
        this.web = source;
    }

    public void extract(VideoInfoUser user, AtomicBoolean stop, Runnable notify) {
        VGetParser ei = null;
        if (YouTubeParser.probe(this.web)) {
            ei = new YouTubeParser(this.web);
        }
        if (VimeoParser.probe(this.web)) {
            ei = new VimeoParser(this.web);
        }
        if (ei == null) {
            throw new RuntimeException("unsupported web site");
        }
        try {
            this.videoDownloads = ((VGetParser)ei).extract(this, stop, notify);
            this.getVideo(this, user, this.videoDownloads);
            this.info.setReferer(this.web);
            this.info.extract(stop, notify);
        }
        catch (DownloadInterruptedError e) {
            this.setState(States.STOP, e);
            throw e;
        }
        catch (RuntimeException e) {
            this.setState(States.ERROR, e);
            throw e;
        }
    }

    public void getVideo(VideoInfo vvi, VideoInfoUser user, List<VGetParser.VideoDownload> sNextVideoURL) {
        if (sNextVideoURL.size() == 0) {
            throw new DownloadRetry("empty video download list, wait until youtube will process the video");
        }
        Collections.sort(sNextVideoURL, new VGetParser.VideoContentFirst());
        for (int i = 0; i < sNextVideoURL.size(); ++i) {
            VGetParser.VideoDownload v = sNextVideoURL.get(i);
            boolean found = true;
            if (user.getUserQuality() != null) {
                found &= user.getUserQuality().equals((Object)v.vq);
            }
            if (!found) continue;
            vvi.setVideoQuality(v.vq);
            DownloadInfo info = new DownloadInfo(v.url);
            vvi.setInfo(info);
            return;
        }
        if (user.getUserQuality() != null) {
            throw new DownloadError("no video user quality found");
        }
        throw new DownloadError("no video with required quality found, increace VideoInfo.setVq to the maximum and retry download");
    }

    public States getState() {
        return this.state;
    }

    public void setState(States state) {
        this.state = state;
        this.exception = null;
        this.delay = 0;
    }

    public void setState(States state, Throwable e) {
        this.state = state;
        this.exception = e;
        this.delay = 0;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay, Throwable e) {
        this.delay = delay;
        this.exception = e;
        this.state = States.RETRYING;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public URL getIcon() {
        return this.icon;
    }

    public void setIcon(URL icon) {
        this.icon = icon;
    }

    public List<VGetParser.VideoDownload> getVideoDownloads() {
        return this.videoDownloads;
    }

    public static enum States {
        QUEUE,
        EXTRACTING,
        EXTRACTING_DONE,
        DOWNLOADING,
        RETRYING,
        DONE,
        ERROR,
        STOP;

    }

    public static enum VideoQuality {
        p3072,
        p2304,
        p1080,
        p720,
        p520,
        p480,
        p360,
        p270,
        p240,
        p224,
        p144;

    }
}

