/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.util;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.dictionary.Dictionary;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public final class CasConsumerUtil {
    private CasConsumerUtil() {
    }

    public static InputStream getOptionalResourceAsStream(UimaContext context, String name) throws ResourceInitializationException {
        try {
            return context.getResourceAsStream(name);
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"There is an internal error in the UIMA SDK: " + e.getMessage(), e});
        }
    }

    public static InputStream getResourceAsStream(UimaContext context, String name) throws ResourceInitializationException {
        InputStream inResource = CasConsumerUtil.getOptionalResourceAsStream(context, name);
        if (inResource == null) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"Unable to load resource!"});
        }
        return inResource;
    }

    public static Type getType(TypeSystem typeSystem, String name) throws ResourceInitializationException {
        Type type = CasConsumerUtil.getOptionalType(typeSystem, name);
        if (type == null) {
            throw new ResourceInitializationException("incompatible_range_types", new Object[]{"Unable to retrive " + name + " type!"});
        }
        return type;
    }

    public static Type getOptionalType(TypeSystem typeSystem, String name) throws ResourceInitializationException {
        return typeSystem.getType(name);
    }

    public static String getRequiredStringParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        String value = CasConsumerUtil.getOptionalStringParameter(context, parameter);
        CasConsumerUtil.checkForNull(value, parameter);
        return value;
    }

    public static Integer getRequiredIntegerParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Integer value = CasConsumerUtil.getOptionalIntegerParameter(context, parameter);
        CasConsumerUtil.checkForNull(value, parameter);
        return value;
    }

    public static Float getRequiredFloatParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Float value = CasConsumerUtil.getOptionalFloatParameter(context, parameter);
        CasConsumerUtil.checkForNull(value, parameter);
        return value;
    }

    public static Boolean getRequiredBooleanParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Boolean value = CasConsumerUtil.getOptionalBooleanParameter(context, parameter);
        CasConsumerUtil.checkForNull(value, parameter);
        return value;
    }

    private static void checkForNull(Object value, String parameterName) throws ResourceInitializationException {
        if (value == null) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The " + parameterName + " is a " + "requiered parameter!"});
        }
    }

    public static String getOptionalStringParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = CasConsumerUtil.getOptionalParameter(context, parameter);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + parameter + " does not have" + "the expected type String"});
    }

    public static String[] getOptionalStringArrayParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = CasConsumerUtil.getOptionalParameter(context, parameter);
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value == null) {
            return new String[0];
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + parameter + " does not have" + "the expected type String array"});
    }

    public static Integer getOptionalIntegerParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = CasConsumerUtil.getOptionalParameter(context, parameter);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + parameter + " does not have" + "the expected type Integer"});
    }

    public static Integer getOptionalIntegerParameter(UimaContext context, String parameter, int defaultValue) throws ResourceInitializationException {
        Integer value = CasConsumerUtil.getOptionalIntegerParameter(context, parameter);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static Float getOptionalFloatParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = CasConsumerUtil.getOptionalParameter(context, parameter);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + parameter + " does not have" + "the expected type Float"});
    }

    public static Boolean getOptionalBooleanParameter(UimaContext context, String parameter) throws ResourceInitializationException {
        Object value = CasConsumerUtil.getOptionalParameter(context, parameter);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The parameter: " + parameter + " does not have" + "the expected type Boolean"});
    }

    private static Object getOptionalParameter(UimaContext context, String parameter) {
        Object value = context.getConfigParameterValue(parameter);
        Logger logger = context.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, parameter + " = " + (value != null ? value.toString() : "not set"));
        }
        return value;
    }

    public static void checkFeatureType(Feature feature, String expectedType) throws ResourceInitializationException {
        if (!feature.getRange().getName().equals(expectedType)) {
            throw new ResourceInitializationException("org.apache.uima.UIMAException_Messages", new Object[]{"The Feature " + feature.getName() + " must be of type " + expectedType + " !"});
        }
    }

    public static Dictionary createOptionalDictionary(UimaContext context, String parameter) throws ResourceInitializationException {
        String dictionaryName = CasConsumerUtil.getOptionalStringParameter(context, parameter);
        Dictionary dictionary = null;
        if (dictionaryName != null) {
            block5: {
                Logger logger = context.getLogger();
                try {
                    InputStream dictIn = CasConsumerUtil.getOptionalResourceAsStream(context, dictionaryName);
                    if (dictIn == null) {
                        String message = "The dictionary file " + dictionaryName + " does not exist!";
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, message);
                        }
                        return null;
                    }
                    dictionary = new Dictionary(dictIn);
                }
                catch (IOException e) {
                    String message = "IOException during dictionary reading, running without dictionary: " + e.getMessage();
                    if (!logger.isLoggable(Level.WARNING)) break block5;
                    logger.log(Level.WARNING, message);
                }
            }
            return dictionary;
        }
        return null;
    }
}

