/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumMap;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.LinkResolver;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.MathVariantMap;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.VariableManager;
import uk.ac.ed.ph.snuggletex.internal.util.ArrayListStack;
import uk.ac.ed.ph.snuggletex.internal.util.StringUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathFunctionInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathIdentifierInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathNumberInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathOperatorInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.BraceContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.ErrorToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.SimpleToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;
import uk.ac.ed.ph.snuggletex.utilities.CSSUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMBuilder {
    private final SessionContext sessionContext;
    private final DOMOutputOptions options;
    private final Element buildRootElement;
    private final Document document;
    private final VariableManager variableManager;
    private Properties currentInlineCSSProperties;
    private final ArrayListStack<OutputContext> outputContextStack;
    private final ArrayListStack<MathVariantMap> mathVariantMapStack;
    private final String lineSeparator = System.getProperty("line.separator");
    private final MathContentBuilderCallback defaultMathContentBuilderCallback = new MathContentBuilderCallback(){

        public void buildMathElementContent(Element contentContainerElement, ArgumentContainerToken mathContentToken, boolean isAnnotated) throws SnuggleParseException {
            if (isAnnotated) {
                DOMBuilder.this.handleMathTokensAsSingleElement(contentContainerElement, mathContentToken);
            } else {
                DOMBuilder.this.handleTokens(contentContainerElement, mathContentToken, false);
            }
        }
    };

    public DOMBuilder(SessionContext sessionContext, Element buildRootElement, DOMOutputOptions options) {
        this.buildRootElement = buildRootElement;
        this.document = buildRootElement.getOwnerDocument();
        this.sessionContext = sessionContext;
        this.options = options;
        this.variableManager = new VariableManager();
        this.currentInlineCSSProperties = null;
        this.outputContextStack = new ArrayListStack();
        this.mathVariantMapStack = new ArrayListStack();
    }

    public void buildDOMSubtree(List<FlowToken> fixedTokens) throws SnuggleParseException {
        this.outputContextStack.clear();
        this.mathVariantMapStack.clear();
        this.outputContextStack.push(OutputContext.XHTML);
        this.handleTokens(this.buildRootElement, fixedTokens, true);
        this.outputContextStack.pop();
        if (!this.mathVariantMapStack.isEmpty()) {
            throw new SnuggleLogicException("mathVariantMapStack was non-empty at end of DOM building process");
        }
        if (!this.outputContextStack.isEmpty()) {
            throw new SnuggleLogicException("outputContextStack was non-empty at end of DOM building process");
        }
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public DOMOutputOptions getOptions() {
        return this.options;
    }

    public Document getDocument() {
        return this.document;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public ArrayListStack<MathVariantMap> getMathVariantMapStack() {
        return this.mathVariantMapStack;
    }

    public OutputContext getOutputContext() {
        return this.outputContextStack.peek();
    }

    public void pushOutputContext(OutputContext outputContext) {
        this.outputContextStack.push(outputContext);
    }

    public OutputContext popOutputContext() {
        return this.outputContextStack.pop();
    }

    public boolean isBuildingMathMLIsland() {
        OutputContext currentOutputContext = this.getOutputContext();
        return currentOutputContext == OutputContext.MATHML_BLOCK || currentOutputContext == OutputContext.MATHML_INLINE;
    }

    public void handleTokens(Element parentElement, ArgumentContainerToken containerToken, boolean trimWhitespace) throws SnuggleParseException {
        this.handleTokens(parentElement, containerToken.getContents(), trimWhitespace);
    }

    public void handleTokens(Element parentElement, List<FlowToken> siblingTokens, boolean trimWhitespace) throws SnuggleParseException {
        NodeList childList;
        int childCountAfter;
        int addedChildCount;
        int childCountBefore = parentElement.getChildNodes().getLength();
        for (FlowToken content : siblingTokens) {
            this.handleToken(parentElement, content);
        }
        if (trimWhitespace && (addedChildCount = (childCountAfter = (childList = parentElement.getChildNodes()).getLength()) - childCountBefore) > 0) {
            Node lastAddedChildNode;
            int firstAddedChildIndex = childCountAfter - addedChildCount;
            int lastAddedChildIndex = childCountAfter - 1;
            Node firstAddedChildNode = childList.item(firstAddedChildIndex);
            if (firstAddedChildNode.getNodeType() == 3) {
                firstAddedChildNode.setNodeValue(firstAddedChildNode.getNodeValue().replaceFirst("^\\s+", ""));
            }
            if ((lastAddedChildNode = childList.item(lastAddedChildIndex)).getNodeType() == 3) {
                lastAddedChildNode.setNodeValue(lastAddedChildNode.getNodeValue().replaceFirst("\\s+$", ""));
            }
        }
    }

    public void handleToken(Element parentElement, FlowToken token) throws SnuggleParseException {
        switch (token.getType()) {
            case BRACE_CONTAINER: {
                BraceContainerToken braceToken = (BraceContainerToken)token;
                ArgumentContainerToken content = braceToken.getBraceContent();
                Element container = null;
                container = braceToken.getLatexMode() == LaTeXMode.MATH ? this.appendMathMLElement(parentElement, "mrow") : this.appendXHTMLElement(parentElement, "span");
                this.handleTokens(container, content, true);
                NodeList childNodes = container.getChildNodes();
                if (childNodes.getLength() != 1) break;
                Node singleNode = childNodes.item(0);
                parentElement.removeChild(container);
                parentElement.appendChild(singleNode);
                break;
            }
            case COMMAND: {
                CommandToken commandToken = (CommandToken)token;
                CommandHandler commandHandler = (CommandHandler)commandToken.getCommand().getDOMBuildingHandler();
                if (commandHandler == null) {
                    throw new SnuggleLogicException("No builder registered for Command " + commandToken.getCommand());
                }
                commandHandler.handleCommand(this, parentElement, commandToken);
                break;
            }
            case ENVIRONMENT: {
                EnvironmentToken envToken = (EnvironmentToken)token;
                EnvironmentHandler envHandler = (EnvironmentHandler)envToken.getEnvironment().getDOMBuildingHandler();
                if (envHandler == null) {
                    throw new SnuggleLogicException("No builder registered for Environment " + envToken.getEnvironment());
                }
                envHandler.handleEnvironment(this, parentElement, envToken);
                break;
            }
            case ERROR: {
                this.appendErrorElement(parentElement, (ErrorToken)token);
                break;
            }
            case TEXT_MODE_TEXT: {
                this.handleTextToken(parentElement, (SimpleToken)token);
                break;
            }
            case VERBATIM_MODE_TEXT: {
                this.appendTextNode(parentElement, token.getSlice().extract().toString(), false);
                break;
            }
            case LR_MODE_NEW_PARAGRAPH: {
                if (this.isBuildingMathMLIsland()) {
                    this.appendMathMLSpace(parentElement, "1ex");
                    break;
                }
                this.appendTextNode(parentElement, " ", false);
                break;
            }
            case MATH_NUMBER: 
            case SINGLE_CHARACTER_MATH_IDENTIFIER: 
            case SINGLE_CHARACTER_MATH_SPECIAL: {
                if (this.isBuildingMathMLIsland()) {
                    this.appendSimpleMathElement(parentElement, token);
                    break;
                }
                throw new SnuggleLogicException("Math Mode token found but outputContext is currently " + this.outputContextStack);
            }
            case TAB_CHARACTER: {
                this.appendOrThrowError(parentElement, token, CoreErrorCode.TDEG00, new Object[0]);
                break;
            }
            default: {
                throw new SnuggleLogicException("Unhandled switch case " + (Object)((Object)token.getType()));
            }
        }
    }

    public void handleTextToken(Element parentElement, SimpleToken textToken) {
        CharSequence rawText = textToken.getSlice().extract();
        StringBuilder resultBuilder = new StringBuilder();
        int i = 0;
        int length = rawText.length();
        while (i < length) {
            char c = rawText.charAt(i);
            switch (c) {
                case '~': {
                    resultBuilder.append('\u00a0');
                    break;
                }
                case '<': {
                    resultBuilder.append('\u00a1');
                    break;
                }
                case '>': {
                    resultBuilder.append('\u00bf');
                    break;
                }
                case '|': {
                    resultBuilder.append('\u2014');
                    break;
                }
                case '`': {
                    if (i + 1 < length && rawText.charAt(i + 1) == '`') {
                        resultBuilder.append('\u201c');
                        ++i;
                        break;
                    }
                    resultBuilder.append('\u2018');
                    break;
                }
                case '\'': {
                    if (i + 1 < length && rawText.charAt(i + 1) == '\'') {
                        resultBuilder.append('\u201d');
                        ++i;
                        break;
                    }
                    resultBuilder.append('\u2019');
                    break;
                }
                case '-': {
                    if (i + 1 < length && rawText.charAt(i + 1) == '-') {
                        if (i + 2 < length && rawText.charAt(i + 2) == '-') {
                            resultBuilder.append('\u2014');
                            i += 2;
                            break;
                        }
                        resultBuilder.append('\u2013');
                        ++i;
                        break;
                    }
                    resultBuilder.append('-');
                    break;
                }
                default: {
                    resultBuilder.append(c);
                }
            }
            ++i;
        }
        String resultString = resultBuilder.toString();
        if (this.isBuildingMathMLIsland()) {
            String trimmed = resultString.trim();
            if (trimmed.length() == 0) {
                this.appendMathMLSpace(parentElement, "1ex");
            } else {
                if (Character.isWhitespace(resultString.charAt(0))) {
                    this.appendMathMLSpace(parentElement, "1ex");
                }
                this.appendMathMLTextElement(parentElement, "mtext", trimmed, false);
                if (Character.isWhitespace(resultString.charAt(resultString.length() - 1))) {
                    this.appendMathMLSpace(parentElement, "1ex");
                }
            }
        } else {
            this.appendTextNode(parentElement, resultString, false);
        }
    }

    public void appendSimpleMathElement(Element parentElement, Token token) {
        EnumMap<InterpretationType, Interpretation> interpretationMap = token.getInterpretationMap();
        if (interpretationMap.containsKey((Object)InterpretationType.MATH_IDENTIFIER)) {
            MathIdentifierInterpretation identifierInterp = (MathIdentifierInterpretation)interpretationMap.get((Object)InterpretationType.MATH_IDENTIFIER);
            this.appendMathMLIdentifierElement(parentElement, identifierInterp.getName());
        } else if (interpretationMap.containsKey((Object)InterpretationType.MATH_NUMBER)) {
            MathNumberInterpretation numberInterp = (MathNumberInterpretation)interpretationMap.get((Object)InterpretationType.MATH_NUMBER);
            this.appendMathMLNumberElement(parentElement, numberInterp.getNumber().toString());
        } else if (interpretationMap.containsKey((Object)InterpretationType.MATH_OPERATOR)) {
            MathOperatorInterpretation operatorInterp = (MathOperatorInterpretation)interpretationMap.get((Object)InterpretationType.MATH_OPERATOR);
            this.appendMathMLOperatorElement(parentElement, operatorInterp.getMathMLOperatorContent());
        } else if (interpretationMap.containsKey((Object)InterpretationType.MATH_FUNCTION)) {
            MathFunctionInterpretation functionInterp = (MathFunctionInterpretation)interpretationMap.get((Object)InterpretationType.MATH_FUNCTION);
            this.appendMathMLIdentifierElement(parentElement, functionInterp.getName());
        } else {
            throw new SnuggleLogicException("Unexpected logic branch based on InterpretationMap, which was: " + interpretationMap);
        }
    }

    public Node appendTextNode(Element parentElement, String content, boolean trim) {
        String toAppend = trim ? content.trim() : content;
        toAppend = toAppend.replace(this.lineSeparator, "\n");
        Node lastChild = parentElement.getLastChild();
        if (lastChild != null && lastChild.getNodeType() == 3) {
            lastChild.setNodeValue(String.valueOf(lastChild.getNodeValue()) + toAppend);
        } else {
            lastChild = this.document.createTextNode(toAppend);
            parentElement.appendChild(lastChild);
        }
        return lastChild;
    }

    public Element appendSnuggleElement(Element parentElement, String elementLocalName) {
        String qName = this.options.isPrefixingSnuggleXML() ? String.valueOf(this.options.getSnuggleXMLPrefix()) + ":" + elementLocalName : elementLocalName;
        Element element = this.document.createElementNS("http://www.ph.ed.ac.uk/snuggletex", qName);
        parentElement.appendChild(element);
        return element;
    }

    public Element appendXHTMLElement(Element parentElement, String elementLocalName) {
        String qName = this.options.isPrefixingXHTML() ? String.valueOf(this.options.getXHTMLPrefix()) + ":" + elementLocalName : elementLocalName;
        Element xhtmlElement = this.document.createElementNS("http://www.w3.org/1999/xhtml", qName);
        parentElement.appendChild(xhtmlElement);
        return xhtmlElement;
    }

    public Element appendXHTMLTextElement(Element parentElement, String elementLocalName, String content, boolean trim) {
        Element xhtmlElement = this.appendXHTMLElement(parentElement, elementLocalName);
        this.appendTextNode(xhtmlElement, content, trim);
        return xhtmlElement;
    }

    public Element appendMathMLElement(Element parentElement, String elementLocalName) {
        String qName = this.options.isPrefixingMathML() ? String.valueOf(this.options.getMathMLPrefix()) + ":" + elementLocalName : elementLocalName;
        Element mathMLElement = this.document.createElementNS("http://www.w3.org/1998/Math/MathML", qName);
        parentElement.appendChild(mathMLElement);
        return mathMLElement;
    }

    public Element appendMathMLTextElement(Element parentElement, String elementLocalName, String content, boolean trim) {
        Element mathMLElement = this.appendMathMLElement(parentElement, elementLocalName);
        this.appendTextNode(mathMLElement, content, trim);
        return mathMLElement;
    }

    public Element appendMathMLSpace(Element parentElement, String width) {
        Element mspaceElement = this.appendMathMLElement(parentElement, "mspace");
        mspaceElement.setAttribute("width", width);
        return mspaceElement;
    }

    public Element appendMathMLOperatorElement(Element parentElement, String content) {
        return this.appendMathMLTextElement(parentElement, "mo", content, true);
    }

    public Element appendMathMLNumberElement(Element parentElement, String number) {
        return this.appendMathMLTextElement(parentElement, "mn", number, true);
    }

    public Element appendMathMLIdentifierElement(Element parentElement, String name) {
        String mappedIdentifier = name;
        String mathVariant = null;
        if (name.length() == 1 && !this.mathVariantMapStack.isEmpty()) {
            char mappedChar;
            MathVariantMap currentMathCharacterMap = this.mathVariantMapStack.peek();
            mathVariant = currentMathCharacterMap.getMathVariantName();
            if (this.options.isMathVariantMapping() && (mappedChar = currentMathCharacterMap.getAccentedChar(name.charAt(0))) != '\u0000') {
                mappedIdentifier = Character.toString(mappedChar);
            }
        }
        Element result = this.appendMathMLTextElement(parentElement, "mi", mappedIdentifier, true);
        if (mathVariant != null) {
            result.setAttribute("mathvariant", mathVariant);
        }
        return result;
    }

    public void handleMathTokensAsSingleElement(Element parentElement, ArgumentContainerToken containerToken) throws SnuggleParseException {
        this.handleMathTokensAsSingleElement(parentElement, containerToken.getContents());
    }

    public void handleMathTokensAsSingleElement(Element parentElement, List<FlowToken> tokens) throws SnuggleParseException {
        Element mrow = this.appendMathMLElement(parentElement, "mrow");
        this.handleTokens(mrow, tokens, true);
        NodeList addedNodes = mrow.getChildNodes();
        if (addedNodes.getLength() == 1) {
            Node addedNode = addedNodes.item(0);
            parentElement.removeChild(mrow);
            parentElement.appendChild(addedNode);
        }
    }

    public NodeList extractNodeListValue(ArgumentContainerToken token) throws SnuggleParseException {
        Element dummyContainer = this.document.createElement("dummy");
        this.handleTokens(dummyContainer, token, true);
        return dummyContainer.getChildNodes();
    }

    public String extractStringValue(ArgumentContainerToken token) throws SnuggleParseException {
        StringBuilder resultBuilder = new StringBuilder();
        this.buildStringValue(resultBuilder, this.extractNodeListValue(token));
        return resultBuilder.toString();
    }

    private void buildStringValue(StringBuilder resultBuilder, NodeList nodes) {
        int i = 0;
        int size = nodes.getLength();
        while (i < size) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) {
                resultBuilder.append(node.getNodeValue());
            } else if (node.getNodeType() == 1) {
                this.buildStringValue(resultBuilder, node.getChildNodes());
            }
            ++i;
        }
    }

    public void applyCSSStyle(Element xhtmlElement, String ... cssClassNames) {
        if (this.options.isInliningCSS()) {
            Properties inlineCSSProperties = this.getCurrentInlineCSSProperties();
            StringBuilder styleBuilder = new StringBuilder();
            boolean needsSemiColon = false;
            String[] stringArray = cssClassNames;
            int n = cssClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String cssClassName = stringArray[n2];
                String property = inlineCSSProperties.getProperty(String.valueOf(xhtmlElement.getLocalName()) + "." + cssClassName);
                if (property == null) {
                    property = inlineCSSProperties.getProperty("." + cssClassName);
                }
                if (needsSemiColon) {
                    styleBuilder.append("; ");
                }
                property = property.trim();
                styleBuilder.append(property);
                needsSemiColon = property.endsWith(";");
                ++n2;
            }
            if (styleBuilder.length() > 0) {
                xhtmlElement.setAttribute("style", styleBuilder.toString());
            }
        } else {
            xhtmlElement.setAttribute("class", StringUtilities.join(cssClassNames, (CharSequence)" "));
        }
    }

    private Properties getCurrentInlineCSSProperties() {
        if (this.currentInlineCSSProperties == null) {
            this.currentInlineCSSProperties = CSSUtilities.readInlineCSSProperties(this.options);
        }
        return this.currentInlineCSSProperties;
    }

    public void buildMathElement(Element parentElement, Token token, ArgumentContainerToken mathContentToken, boolean isDisplayMath) throws SnuggleParseException {
        this.buildMathElement(parentElement, token, mathContentToken, isDisplayMath, this.defaultMathContentBuilderCallback);
    }

    public void buildMathElement(Element parentElement, Token token, ArgumentContainerToken mathContentToken, boolean isDisplayMath, MathContentBuilderCallback mathContentBuilderCallback) throws SnuggleParseException {
        this.pushOutputContext(isDisplayMath ? OutputContext.MATHML_BLOCK : OutputContext.MATHML_INLINE);
        Element math = this.appendMathMLElement(parentElement, "math");
        if (isDisplayMath) {
            math.setAttribute("display", "block");
        }
        if (this.options.isAddingMathSourceAnnotations()) {
            Element container;
            Element semantics = this.appendMathMLElement(math, "semantics");
            if (this.options.isApplyingFirefox3SemanticsWorkaround() && isDisplayMath) {
                container = this.appendMathMLElement(semantics, "mstyle");
                container.setAttribute("displaystyle", "true");
            } else {
                container = semantics;
            }
            mathContentBuilderCallback.buildMathElementContent(container, mathContentToken, true);
            String annotationContent = token.getSlice().extract().toString();
            Element sourceAnnotation = this.appendMathMLTextElement(semantics, "annotation", annotationContent, true);
            sourceAnnotation.setAttribute("encoding", "SnuggleTeX");
        } else {
            mathContentBuilderCallback.buildMathElementContent(math, mathContentToken, false);
        }
        this.popOutputContext();
    }

    public Element findNearestXHTMLAncestorOrSelf(Element element) {
        Element currentElement = element;
        while (currentElement != this.buildRootElement) {
            if ("http://www.w3.org/1999/xhtml".equals(currentElement.getNamespaceURI())) {
                return currentElement;
            }
            Node parentNode = currentElement.getParentNode();
            if (parentNode == null || parentNode.getNodeType() != 1) {
                throw new SnuggleLogicException("Traversed up DOM tree and never found our root Element!");
            }
            currentElement = (Element)parentNode;
        }
        return currentElement;
    }

    public boolean isParentElement(Element parentElement, String requiredNamespaceUri, String ... requiredLocalNames) {
        if (!requiredNamespaceUri.equals(parentElement.getNamespaceURI())) {
            return false;
        }
        if (requiredLocalNames.length == 0) {
            return true;
        }
        String localName = parentElement.getLocalName();
        String[] stringArray = requiredLocalNames;
        int n = requiredLocalNames.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedLocalName = stringArray[n2];
            if (localName.equals(allowedLocalName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String validateXMLName(Element parentElement, Token nameToken, String rawName) throws SnuggleParseException {
        if (!XMLUtilities.isXMLName(rawName)) {
            this.appendOrThrowError(parentElement, nameToken, CoreErrorCode.TDEX03, rawName);
            return null;
        }
        return rawName;
    }

    public String validateXMLId(Element parentElement, Token nameToken, String rawName) throws SnuggleParseException {
        String validatedName = this.validateXMLName(parentElement, nameToken, rawName);
        if (validatedName != null && this.document.getElementById(validatedName) != null) {
            this.appendOrThrowError(parentElement, nameToken, CoreErrorCode.TDEX05, rawName);
            return null;
        }
        return validatedName;
    }

    public URI validateURI(Element parentElement, Token token, String rawURI) throws SnuggleParseException {
        URI result;
        try {
            result = new URI(rawURI);
        }
        catch (URISyntaxException e) {
            this.appendOrThrowError(parentElement, token, CoreErrorCode.TDEX04, rawURI);
            return null;
        }
        return result;
    }

    public URI resolveLink(Element parentElement, Token token, String rawHref) throws SnuggleParseException {
        URI result = this.validateURI(parentElement, token, rawHref);
        if (result == null) {
            return null;
        }
        LinkResolver linkResolver = this.options.getLinkResolver();
        if (linkResolver != null) {
            result = linkResolver.mapLink(result, token.getSlice().getDocument().getInput().getURI());
        }
        return result;
    }

    public Element appendOrThrowError(Element parentElement, Token token, ErrorCode errorCode, Object ... arguments) throws SnuggleParseException {
        InputError error = new InputError(errorCode, token.getSlice(), arguments);
        this.sessionContext.registerError(error);
        return this.appendErrorElement(parentElement, new ErrorToken(error, token.getLatexMode()));
    }

    public Element appendErrorElement(Element parentElement, ErrorToken errorToken) {
        DOMOutputOptions.ErrorOutputOptions errorOptions = this.options.getErrorOutputOptions();
        switch (errorOptions) {
            case NO_OUTPUT: {
                break;
            }
            case XML_SHORT: 
            case XML_FULL: {
                Element errorElement = MessageFormatter.formatErrorAsXML(this.document, errorToken.getError(), errorOptions == DOMOutputOptions.ErrorOutputOptions.XML_FULL);
                parentElement.appendChild(errorElement);
                break;
            }
            case XHTML: {
                if (this.isBuildingMathMLIsland()) {
                    Element merror = this.appendMathMLElement(parentElement, "merror");
                    this.appendMathMLTextElement(merror, "mtext", errorToken.getError().getErrorCode().toString(), false);
                }
                Element ancestorElement = this.findNearestXHTMLAncestorOrSelf(parentElement);
                Element errorElement = MessageFormatter.formatErrorAsXHTML(this.document, errorToken.getError());
                ancestorElement.appendChild(errorElement);
                break;
            }
            default: {
                throw new SnuggleLogicException("Unexpected switch case " + (Object)((Object)errorOptions));
            }
        }
        return parentElement;
    }

    public static interface MathContentBuilderCallback {
        public void buildMathElementContent(Element var1, ArgumentContainerToken var2, boolean var3) throws SnuggleParseException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputContext {
        XHTML,
        MATHML_BLOCK,
        MATHML_INLINE;

    }
}

