/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.CombinerTargetMatcher;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.util.StringUtilities;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathBracketInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathOperatorInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathFenceHandler
implements EnvironmentHandler {
    @Override
    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token) throws SnuggleParseException {
        ArgumentContainerToken contentContainer = token.getContent();
        String opener = this.getBracket(token.getArguments()[0]);
        String closer = this.getBracket(token.getArguments()[1]);
        if (opener != null && closer != null) {
            this.makeMfenced(builder, parentElement, contentContainer, opener, closer);
        } else {
            this.makeBracketed(builder, parentElement, contentContainer, opener, closer);
        }
    }

    private void makeMfenced(DOMBuilder builder, Element parentElement, ArgumentContainerToken contentContainer, String opener, String closer) throws SnuggleParseException {
        Element mfenced = builder.appendMathMLElement(parentElement, "mfenced");
        mfenced.setAttribute("open", StringUtilities.emptyIfNull(opener));
        mfenced.setAttribute("close", StringUtilities.emptyIfNull(closer));
        ArrayList<FlowToken> groupBuilder = new ArrayList<FlowToken>();
        for (FlowToken contentToken : contentContainer) {
            if (contentToken.hasInterpretationType(InterpretationType.MATH_OPERATOR) && ((MathOperatorInterpretation)contentToken.getInterpretation(InterpretationType.MATH_OPERATOR)).getMathMLOperatorContent() == ",") {
                this.makeFenceGroup(builder, mfenced, groupBuilder);
                groupBuilder.clear();
                continue;
            }
            groupBuilder.add(contentToken);
        }
        if (!groupBuilder.isEmpty()) {
            this.makeFenceGroup(builder, mfenced, groupBuilder);
        }
    }

    private void makeBracketed(DOMBuilder builder, Element parentElement, ArgumentContainerToken contentContainer, String opener, String closer) throws SnuggleParseException {
        Element mrow = builder.appendMathMLElement(parentElement, "mrow");
        if (opener != null) {
            builder.appendMathMLOperatorElement(mrow, opener);
        }
        for (FlowToken contentToken : contentContainer) {
            builder.handleToken(mrow, contentToken);
        }
        if (closer != null) {
            builder.appendMathMLOperatorElement(mrow, closer);
        }
    }

    private void makeFenceGroup(DOMBuilder builder, Element mfenced, List<FlowToken> groupContents) throws SnuggleParseException {
        builder.handleMathTokensAsSingleElement(mfenced, groupContents);
    }

    private String getBracket(ArgumentContainerToken argumentContainerToken) {
        List<FlowToken> contents = argumentContainerToken.getContents();
        String result = null;
        if (!contents.isEmpty()) {
            FlowToken bracketToken = contents.get(0);
            if (bracketToken.hasInterpretationType(InterpretationType.MATH_OPERATOR)) {
                MathOperatorInterpretation mathOperatorInterp = (MathOperatorInterpretation)bracketToken.getInterpretation(InterpretationType.MATH_OPERATOR);
                if (bracketToken.hasInterpretationType(InterpretationType.MATH_BRACKET)) {
                    result = ((MathBracketInterpretation)bracketToken.getInterpretation(InterpretationType.MATH_BRACKET)).getMfencedAttributeContent();
                } else if (bracketToken.hasInterpretationType(InterpretationType.MATH_OPERATOR) && mathOperatorInterp.getMathMLOperatorContent() == ".") {
                    result = "";
                }
            }
            if (result == null) {
                throw new SnuggleLogicException("Bracket combiner was not of the expected form");
            }
        }
        return result;
    }

    public static final class BracketCombinerTargetMatcher
    implements CombinerTargetMatcher {
        public boolean isAllowed(FlowToken target) {
            MathOperatorInterpretation operatorInterp;
            boolean isAllowed = false;
            if (target.hasInterpretationType(InterpretationType.MATH_BRACKET)) {
                isAllowed = true;
            } else if (target.hasInterpretationType(InterpretationType.MATH_OPERATOR) && (operatorInterp = (MathOperatorInterpretation)target.getInterpretation(InterpretationType.MATH_OPERATOR)).getMathMLOperatorContent() == ".") {
                isAllowed = true;
            }
            return isAllowed;
        }
    }
}

