/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.knn.ByteNearestNeighbours;
import org.openimaj.knn.ByteNearestNeighboursProvider;
import org.openimaj.knn.approximate.ByteNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntFloatPair;

public class KDTreeByteEuclideanAssigner
implements HardAssigner<byte[], float[], IntFloatPair> {
    protected ByteNearestNeighboursKDTree nn;

    public KDTreeByteEuclideanAssigner(CentroidsProvider<byte[]> provider) {
        ByteNearestNeighbours internal;
        if (provider instanceof ByteNearestNeighboursProvider && (internal = ((ByteNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof ByteNearestNeighboursKDTree) {
            this.nn = (ByteNearestNeighboursKDTree)internal;
            return;
        }
        this.nn = new ByteNearestNeighboursKDTree((byte[][])provider.getCentroids(), 8, 768);
    }

    public KDTreeByteEuclideanAssigner(byte[][] data) {
        this.nn = new ByteNearestNeighboursKDTree(data, 8, 768);
    }

    public int[] assign(byte[][] data) {
        int[] argmins = new int[data.length];
        float[] mins = new float[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(byte[] data) {
        return this.assign(new byte[][]{data})[0];
    }

    public void assignDistance(byte[][] data, int[] indices, float[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntFloatPair assignDistance(byte[] data) {
        int[] index = new int[1];
        float[] distance = new float[1];
        this.nn.searchNN((byte[][])new byte[][]{data}, index, distance);
        return new IntFloatPair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }
}

