/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import java.lang.reflect.Array;
import java.util.List;
import org.openimaj.feature.FeatureVector;
import org.openimaj.knn.ObjectNearestNeighboursExact;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.comparator.DistanceComparator;
import org.openimaj.util.pair.IntFloatPair;

public class ExactFeatureVectorAssigner<T extends FeatureVector>
implements HardAssigner<T, float[], IntFloatPair> {
    protected ObjectNearestNeighboursExact<T> nn;
    protected int ndims;
    protected Class<T> clz;

    public ExactFeatureVectorAssigner(CentroidsProvider<T> provider, DistanceComparator<? super T> comparison) {
        Object[] centroids = (FeatureVector[])provider.getCentroids();
        this.nn = new ObjectNearestNeighboursExact(centroids, comparison);
        this.ndims = centroids[0].length();
        this.clz = centroids.getClass().getComponentType();
    }

    public ExactFeatureVectorAssigner(T[] data, DistanceComparator<? super T> comparison) {
        this.nn = new ObjectNearestNeighboursExact((Object[])data, comparison);
        this.ndims = data[0].length();
        this.clz = data.getClass().getComponentType();
    }

    public ExactFeatureVectorAssigner(List<T> data, DistanceComparator<? super T> comparison) {
        this.nn = new ObjectNearestNeighboursExact(data, comparison);
        this.ndims = ((FeatureVector)data.get(0)).length();
        this.clz = ((FeatureVector)data.get(0)).getClass();
    }

    @Override
    public int[] assign(T[] data) {
        int[] argmins = new int[data.length];
        float[] mins = new float[data.length];
        this.nn.searchNN((Object[])data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(T data) {
        FeatureVector[] arr = (FeatureVector[])Array.newInstance(this.clz, 1);
        arr[0] = data;
        return this.assign(arr)[0];
    }

    @Override
    public void assignDistance(T[] data, int[] indices, float[] distances) {
        this.nn.searchNN((Object[])data, indices, distances);
    }

    @Override
    public IntFloatPair assignDistance(T data) {
        int[] index = new int[1];
        float[] distance = new float[1];
        Object[] arr = (FeatureVector[])Array.newInstance(this.clz, 1);
        arr[0] = data;
        this.nn.searchNN(arr, index, distance);
        return new IntFloatPair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.ndims;
    }

    public ObjectNearestNeighboursExact<T> getNN() {
        return this.nn;
    }
}

