/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.cluster;

import ch.akuhn.matrix.SparseMatrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.experiment.evaluation.Evaluator;
import org.openimaj.experiment.evaluation.cluster.ClusterEvaluator;
import org.openimaj.experiment.evaluation.cluster.RangedAnalysisResult;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyser;
import org.openimaj.experiment.evaluation.cluster.processor.Clusterer;
import org.openimaj.ml.clustering.dbscan.SparseMatrixDBSCAN;
import org.openimaj.util.function.Function;
import org.openimaj.util.iterator.UniformDoubleRangeIterable;

public class RangedDBSCANClusterEvaluator<D, T extends AnalysisResult>
implements Evaluator<Map<Double, int[][]>, RangedAnalysisResult<Double, T>> {
    private int[][] correct;
    private ClusterAnalyser<T> analyser;
    private SparseMatrixDBSCAN gen;
    private SparseMatrix data;
    UniformDoubleRangeIterable r;

    public RangedDBSCANClusterEvaluator(UniformDoubleRangeIterable r, SparseMatrixDBSCAN gen, SparseMatrix data, int[][] clusters, ClusterAnalyser<T> analyser) {
        this.gen = gen;
        this.correct = clusters;
        this.analyser = analyser;
        this.data = data;
    }

    public <A, B> RangedDBSCANClusterEvaluator(UniformDoubleRangeIterable r, SparseMatrixDBSCAN gen, SparseMatrix data, Map<A, ? extends List<B>> dataset, ClusterAnalyser<T> analyser) {
        this.r = r;
        this.gen = gen;
        this.correct = new int[dataset.size()][];
        int j = 0;
        int k = 0;
        for (Map.Entry<A, List<B>> es : dataset.entrySet()) {
            this.correct[j] = new int[es.getValue().size()];
            int i = 0;
            List<B> value = es.getValue();
            for (int l = 0; l < value.size(); ++l) {
                this.correct[j][i++] = k++;
            }
            ++j;
        }
        this.analyser = analyser;
        this.data = data;
    }

    public <A, B> RangedDBSCANClusterEvaluator(UniformDoubleRangeIterable r, SparseMatrixDBSCAN gen, SparseMatrix data, Function<B, Integer> indexFunc, Map<A, ? extends List<B>> dataset, ClusterAnalyser<T> analyser) {
        this.r = r;
        this.gen = gen;
        this.correct = new int[dataset.size()][];
        int j = 0;
        for (Map.Entry<A, List<B>> es : dataset.entrySet()) {
            this.correct[j] = new int[es.getValue().size()];
            int i = 0;
            List<B> value = es.getValue();
            for (B b : value) {
                this.correct[j][i++] = (Integer)indexFunc.apply(b);
            }
            ++j;
        }
        this.analyser = analyser;
        this.data = data;
    }

    public <A, B> RangedDBSCANClusterEvaluator(UniformDoubleRangeIterable r, SparseMatrixDBSCAN gen, Map<A, ? extends List<B>> dataset, Function<List<B>, SparseMatrix> transform, ClusterAnalyser<T> analyser) {
        this.r = r;
        this.gen = gen;
        this.analyser = analyser;
        this.correct = new int[dataset.size()][];
        int j = 0;
        ArrayList<B> flattened = new ArrayList<B>();
        for (Map.Entry<A, List<B>> es : dataset.entrySet()) {
            this.correct[j] = new int[es.getValue().size()];
            int i = 0;
            for (B b : es.getValue()) {
                this.correct[j][i++] = flattened.size();
                flattened.add(b);
            }
            ++j;
        }
        this.data = (SparseMatrix)transform.apply(flattened);
    }

    public Map<Double, int[][]> evaluate() {
        HashMap<Double, int[][]> ret = new HashMap<Double, int[][]>();
        for (Double eps : this.r) {
            this.gen.setEps(eps);
            ret.put(eps, new ClusterEvaluator((Clusterer)this.gen, (Object)this.data, this.correct, this.analyser).evaluate());
        }
        return ret;
    }

    public RangedAnalysisResult<Double, T> analyse(Map<Double, int[][]> estimated) {
        RangedAnalysisResult ret = new RangedAnalysisResult();
        for (Map.Entry<Double, int[][]> ent : estimated.entrySet()) {
            ret.put(ent.getKey(), this.analyser.analyse(this.correct, ent.getValue()));
        }
        return ret;
    }
}

