/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector.weighter.global;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorUtil;
import gov.sandia.cognition.text.term.vector.weighter.global.AbstractFrequencyBasedGlobalTermWeighter;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReference(author={"Wikipedia"}, title="tf-idf", type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/tf-idf", year=2009)
public class InverseDocumentFrequencyGlobalTermWeighter
extends AbstractFrequencyBasedGlobalTermWeighter {
    protected Vector inverseDocumentFrequency;

    public InverseDocumentFrequencyGlobalTermWeighter() {
        this((VectorFactory<? extends Vector>)SparseVectorFactory.getDefault());
    }

    public InverseDocumentFrequencyGlobalTermWeighter(VectorFactory<? extends Vector> vectorFactory) {
        super(vectorFactory);
    }

    @Override
    public InverseDocumentFrequencyGlobalTermWeighter clone() {
        InverseDocumentFrequencyGlobalTermWeighter clone = (InverseDocumentFrequencyGlobalTermWeighter)super.clone();
        clone.inverseDocumentFrequency = (Vector)ObjectUtil.cloneSafe((CloneableSerializable)this.inverseDocumentFrequency);
        return clone;
    }

    @Override
    public void add(Vector counts) {
        super.add(counts);
        this.setInverseDocumentFrequency(null);
    }

    @Override
    public boolean remove(Vector counts) {
        boolean result = super.remove(counts);
        if (result) {
            this.setInverseDocumentFrequency(null);
        }
        return result;
    }

    @Override
    public int getDimensionality() {
        return VectorUtil.safeGetDimensionality((Vector)this.getTermDocumentFrequencies());
    }

    @Override
    public Vector getGlobalWeights() {
        return this.getInverseDocumentFrequency();
    }

    public Vector getInverseDocumentFrequency() {
        if (this.inverseDocumentFrequency == null && this.termDocumentFrequencies != null) {
            Vector newIDFs = this.getVectorFactory().copyVector(this.termDocumentFrequencies);
            for (VectorEntry entry : newIDFs) {
                double count = entry.getValue();
                if (!(count > 0.0)) continue;
                double idf = Math.log((double)this.documentCount / count);
                entry.setValue(idf);
            }
            this.setInverseDocumentFrequency(newIDFs);
        }
        return this.inverseDocumentFrequency;
    }

    protected void setInverseDocumentFrequency(Vector inverseDocumentFrequency) {
        this.inverseDocumentFrequency = inverseDocumentFrequency;
    }
}

