/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector.weighter.global;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.DimensionalityMismatchException;
import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.text.term.vector.weighter.global.AbstractGlobalTermWeighter;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public abstract class AbstractFrequencyBasedGlobalTermWeighter
extends AbstractGlobalTermWeighter {
    protected int documentCount;
    protected Vector termDocumentFrequencies;
    protected Vector termGlobalFrequencies;

    public AbstractFrequencyBasedGlobalTermWeighter() {
        this((VectorFactory<? extends Vector>)SparseVectorFactory.getDefault());
    }

    public AbstractFrequencyBasedGlobalTermWeighter(VectorFactory<? extends Vector> vectorFactory) {
        super(vectorFactory);
        this.setDocumentCount(0);
        this.setTermDocumentFrequencies(null);
        this.setTermGlobalFrequencies(null);
    }

    public AbstractFrequencyBasedGlobalTermWeighter clone() {
        AbstractFrequencyBasedGlobalTermWeighter clone = (AbstractFrequencyBasedGlobalTermWeighter)super.clone();
        clone.termDocumentFrequencies = (Vector)ObjectUtil.cloneSafe((CloneableSerializable)this.termDocumentFrequencies);
        clone.termGlobalFrequencies = (Vector)ObjectUtil.cloneSafe((CloneableSerializable)this.termGlobalFrequencies);
        return clone;
    }

    @Override
    public void add(Vector counts) {
        int dimensionality = counts.getDimensionality();
        if (this.termDocumentFrequencies == null) {
            this.initializeVectors(dimensionality);
        } else {
            int currentDimensionality = this.termDocumentFrequencies.getDimensionality();
            if (dimensionality < currentDimensionality) {
                throw new DimensionalityMismatchException("dimensionality must be at least " + this.termDocumentFrequencies.getDimensionality());
            }
            if (dimensionality > currentDimensionality) {
                this.growVectors(dimensionality);
                currentDimensionality = dimensionality;
            }
        }
        ++this.documentCount;
        this.termGlobalFrequencies.plusEquals((Ring)counts);
        for (VectorEntry entry : counts) {
            if (entry.getValue() == 0.0) continue;
            int index = entry.getIndex();
            double count = this.termDocumentFrequencies.getElement(index) + 1.0;
            this.termDocumentFrequencies.setElement(index, count);
        }
    }

    @Override
    public boolean remove(Vector counts) {
        this.termDocumentFrequencies.assertSameDimensionality(counts);
        --this.documentCount;
        this.termGlobalFrequencies.minusEquals((Ring)counts);
        for (VectorEntry entry : counts) {
            if (entry.getValue() == 0.0) continue;
            int index = entry.getIndex();
            double count = this.termDocumentFrequencies.getElement(index) - 1.0;
            this.termDocumentFrequencies.setElement(index, count);
        }
        return true;
    }

    protected void initializeVectors(int dimensionality) {
        this.termDocumentFrequencies = this.getVectorFactory().createVector(dimensionality);
        this.termGlobalFrequencies = this.getVectorFactory().createVector(dimensionality);
    }

    protected void growVectors(int newDimensionality) {
        Vector difference = this.getVectorFactory().createVector(newDimensionality - this.termDocumentFrequencies.getDimensionality());
        this.termDocumentFrequencies = this.termDocumentFrequencies.stack(difference);
        this.termGlobalFrequencies = this.termGlobalFrequencies.stack(difference);
    }

    @Override
    public int getDocumentCount() {
        return this.documentCount;
    }

    protected void setDocumentCount(int documentCount) {
        this.documentCount = documentCount;
    }

    public Vector getTermDocumentFrequencies() {
        return this.termDocumentFrequencies;
    }

    protected void setTermDocumentFrequencies(Vector termDocumentFrequencies) {
        this.termDocumentFrequencies = termDocumentFrequencies;
    }

    public Vector getTermGlobalFrequencies() {
        return this.termGlobalFrequencies;
    }

    protected void setTermGlobalFrequencies(Vector termGlobalFrequencies) {
        this.termGlobalFrequencies = termGlobalFrequencies;
    }
}

