/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector.weighter;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.text.term.vector.weighter.CompositeLocalGlobalTermWeighter;
import gov.sandia.cognition.text.term.vector.weighter.global.DominanceGlobalTermWeighter;
import gov.sandia.cognition.text.term.vector.weighter.global.EntropyGlobalTermWeighter;
import gov.sandia.cognition.text.term.vector.weighter.global.InverseDocumentFrequencyGlobalTermWeighter;
import gov.sandia.cognition.text.term.vector.weighter.local.LogLocalTermWeighter;
import gov.sandia.cognition.text.term.vector.weighter.local.TermFrequencyLocalTermWeighter;
import gov.sandia.cognition.text.term.vector.weighter.normalize.UnitTermWeightNormalizer;

public class CommonTermWeighterFactory {
    private CommonTermWeighterFactory() {
    }

    public static CompositeLocalGlobalTermWeighter createTFWeighter() {
        return new CompositeLocalGlobalTermWeighter(new TermFrequencyLocalTermWeighter(), null, null);
    }

    @PublicationReference(author={"Wikipedia"}, title="tf-idf", type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/tf-idf", year=2009)
    public static CompositeLocalGlobalTermWeighter createTFIDFWeighter() {
        return new CompositeLocalGlobalTermWeighter(new TermFrequencyLocalTermWeighter(), new InverseDocumentFrequencyGlobalTermWeighter(), null);
    }

    public static CompositeLocalGlobalTermWeighter createTFIDFWeighterWithUnitNormalization() {
        return new CompositeLocalGlobalTermWeighter(new TermFrequencyLocalTermWeighter(), new InverseDocumentFrequencyGlobalTermWeighter(), new UnitTermWeightNormalizer());
    }

    @PublicationReference(author={"Susan T. Dumais"}, title="Improving the retrieval of information from external sources", year=1991, type=PublicationType.Journal, publication="Behavior Research Methods, Instruments, and Computers", pages={229, 236}, url="http://www.google.com/url?sa=t&source=web&ct=res&cd=1&url=http%3A%2F%2Fwww.psychonomic.org%2Fsearch%2Fview.cgi%3Fid%3D5145&ei=o7joSdGEHY-itgPLre3tAQ&usg=AFQjCNEvm6PZEL6_Hk3XThI6DQ-gGx9EnQ&sig2=-gjFzNroJQirwGtwjaJvgQ")
    public static CompositeLocalGlobalTermWeighter createLogEntropyWeighter() {
        return new CompositeLocalGlobalTermWeighter(new LogLocalTermWeighter(), new EntropyGlobalTermWeighter(), null);
    }

    public static CompositeLocalGlobalTermWeighter createLogDominanceWeighter() {
        return new CompositeLocalGlobalTermWeighter(new LogLocalTermWeighter(), new DominanceGlobalTermWeighter(), null);
    }
}

