/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.filter.stem;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.text.term.DefaultTerm;
import gov.sandia.cognition.text.term.DefaultTermOccurrence;
import gov.sandia.cognition.text.term.TermOccurrence;
import gov.sandia.cognition.text.term.filter.AbstractSingleTermFilter;
import org.tartarus.martin.Stemmer;

@PublicationReferences(references={@PublicationReference(author={"Martin Porter"}, title="The Porter Stemming Algorithm", year=2006, type=PublicationType.WebPage, url="http://tartarus.org/~martin/PorterStemmer/"), @PublicationReference(author={"Martin F. Porter"}, title=" An algorithm for suffix stripping", year=1980, publication="Program 14(3)", pages={130, 137}, type=PublicationType.Journal), @PublicationReference(author={"Wikipedia"}, title="Stemming", year=2010, type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Stemming")})
public class PorterEnglishStemmingFilter
extends AbstractSingleTermFilter {
    @Override
    public TermOccurrence filterTerm(TermOccurrence occurrence) {
        String oldText = occurrence.getTerm().getName();
        Stemmer stemmer = new Stemmer();
        stemmer.add(oldText.toCharArray(), oldText.length());
        stemmer.stem();
        String newText = stemmer.toString();
        DefaultTerm newTerm = new DefaultTerm(newText);
        DefaultTermOccurrence newOccurrence = new DefaultTermOccurrence(newTerm, occurrence.getStart(), occurrence.getLength());
        return newOccurrence;
    }

    public static String stem(String word) {
        Stemmer stemmer = new Stemmer();
        stemmer.add(word.toCharArray(), word.length());
        stemmer.stem();
        return stemmer.toString();
    }
}

