/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.filter;

import gov.sandia.cognition.text.term.DefaultTermNGram;
import gov.sandia.cognition.text.term.DefaultTermOccurrence;
import gov.sandia.cognition.text.term.Term;
import gov.sandia.cognition.text.term.TermOccurrence;
import gov.sandia.cognition.text.term.filter.TermFilter;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class NGramFilter
extends AbstractCloneableSerializable
implements TermFilter {
    public static final int DEFAULT_SIZE = 2;
    protected int size;

    public NGramFilter() {
        this(2);
    }

    public NGramFilter(int size) {
        this.setSize(size);
    }

    public NGramFilter clone() {
        return (NGramFilter)super.clone();
    }

    public Collection<TermOccurrence> filterTerms(Iterable<? extends TermOccurrence> terms) {
        LinkedList<TermOccurrence> result = new LinkedList<TermOccurrence>();
        LinkedList<TermOccurrence> occurrencesBuffer = new LinkedList<TermOccurrence>();
        Term[] previousTerms = new Term[this.size];
        Iterator<? extends TermOccurrence> it = terms.iterator();
        boolean keepGoing = it.hasNext();
        while (keepGoing) {
            Term term;
            Term[] currentTerms = new Term[this.size];
            for (int i = 1; i < this.size; ++i) {
                currentTerms[i - 1] = previousTerms[i];
            }
            TermOccurrence occurrence = it.hasNext() ? it.next() : null;
            Term term2 = term = occurrence != null ? occurrence.getTerm() : null;
            if (occurrencesBuffer.size() >= this.size || occurrence == null) {
                occurrencesBuffer.removeFirst();
            }
            if (occurrence != null) {
                occurrencesBuffer.addLast(occurrence);
            }
            currentTerms[this.size - 1] = term;
            DefaultTermNGram nGram = new DefaultTermNGram(currentTerms);
            TermOccurrence first = (TermOccurrence)occurrencesBuffer.getFirst();
            TermOccurrence last = (TermOccurrence)occurrencesBuffer.getLast();
            int start = first.getStart();
            int end = last.getStart() + last.getLength();
            int length = end - start;
            result.add(new DefaultTermOccurrence(nGram, start, length));
            previousTerms = currentTerms;
            keepGoing = it.hasNext() || occurrencesBuffer.size() > 1;
        }
        return result;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size <= 1) {
            throw new IllegalArgumentException("size must be greater than 1");
        }
        this.size = size;
    }
}

