/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term;

import gov.sandia.cognition.text.term.IndexedTerm;
import gov.sandia.cognition.text.term.Term;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public class DefaultIndexedTerm
extends AbstractCloneableSerializable
implements IndexedTerm {
    public static final int DEFAULT_INDEX = -1;
    protected int index;
    protected Term term;

    public DefaultIndexedTerm() {
        this(-1, null);
    }

    public DefaultIndexedTerm(int index, Term term) {
        this.setIndex(index);
        this.setTerm(term);
    }

    public DefaultIndexedTerm clone() {
        DefaultIndexedTerm clone = (DefaultIndexedTerm)super.clone();
        clone.term = (Term)ObjectUtil.cloneSafe((CloneableSerializable)this.term);
        return clone;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + this.index;
        hash = 89 * hash + (this.term != null ? this.term.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof DefaultIndexedTerm && this.equals((DefaultIndexedTerm)other);
    }

    public boolean equals(DefaultIndexedTerm other) {
        return other != null && this.index == other.index && ObjectUtil.equalsSafe((Object)this.term, (Object)other.term);
    }

    @Override
    public Term asTerm() {
        return this.getTerm();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Term getTerm() {
        return this.term;
    }

    protected void setTerm(Term term) {
        this.term = term;
    }

    public String toString() {
        return "(" + this.index + ", " + this.term + ")";
    }
}

