/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.document;

import gov.sandia.cognition.io.FileUtil;
import gov.sandia.cognition.text.document.AbstractDocument;
import gov.sandia.cognition.text.document.DefaultDateField;
import gov.sandia.cognition.text.document.DefaultTextField;
import gov.sandia.cognition.text.document.Field;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;

public class DefaultDocument
extends AbstractDocument {
    public DefaultDocument() {
        this.setAccessedDate(System.currentTimeMillis());
    }

    @Override
    public void addField(Field field) {
        super.addField(field);
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
    }

    public void setTitle(String title) {
        this.addField(new DefaultTextField("title", title));
    }

    public void setLastModifiedDate(long time) {
        this.setLastModifiedDate(new Date(time));
    }

    public void setLastModifiedDate(Date date) {
        this.addField(new DefaultDateField("lastModifiedDate", date));
    }

    public void setAccessedDate(long time) {
        this.setAccessedDate(new Date(time));
    }

    public void setAccessedDate(Date date) {
        this.addField(new DefaultDateField("accessedDate", date));
    }

    public void setAuthor(String author) {
        this.addField(new DefaultTextField("author", author));
    }

    public void setBody(String body) {
        this.addField(new DefaultTextField("body", body));
    }

    public void readMetaData(URLConnection connection) {
        URL url = connection.getURL();
        String fileFullName = url.getFile();
        String fileName = new File(fileFullName).getName();
        this.setName(fileName);
        this.setTitle(FileUtil.removeExtension((String)fileName));
        this.setLastModifiedDate(connection.getLastModified());
    }
}

