/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import java.util.Date;

public class MatFileHeader {
    private static String DEFAULT_DESCRIPTIVE_TEXT = "MATLAB 5.0 MAT-file, Platform: " + System.getProperty("os.name") + ", CREATED on: ";
    private static int DEFAULT_VERSION = 256;
    private static byte[] DEFAULT_ENDIAN_INDICATOR = new byte[]{77, 73};
    private int version;
    private String description;
    private byte[] endianIndicator;

    public MatFileHeader(String description, int version, byte[] endianIndicator) {
        this.description = description;
        this.version = version;
        this.endianIndicator = endianIndicator;
    }

    public String getDescription() {
        return this.description;
    }

    public byte[] getEndianIndicator() {
        return this.endianIndicator;
    }

    public int getVersion() {
        return this.version;
    }

    public static MatFileHeader createHeader() {
        return new MatFileHeader(String.valueOf(DEFAULT_DESCRIPTIVE_TEXT) + new Date().toString(), DEFAULT_VERSION, DEFAULT_ENDIAN_INDICATOR);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("desriptive text: " + this.description);
        sb.append(", version: " + this.version);
        sb.append(", endianIndicator: " + new String(this.endianIndicator));
        sb.append("]");
        return sb.toString();
    }
}

