/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.ShortFVComparison;
import org.openimaj.util.concatenate.Concatenatable;

public class ShortFV
extends ArrayFeatureVector<short[]>
implements Concatenatable<ShortFV, ShortFV>,
Cloneable {
    private static final long serialVersionUID = 1L;

    public ShortFV() {
    }

    public ShortFV(int nbins) {
        this.values = new short[nbins];
    }

    public ShortFV(short[] values) {
        this.values = values;
    }

    public short get(int x) {
        return ((short[])this.values)[x];
    }

    void set(short value, int x) {
        ((short[])this.values)[x] = value;
    }

    @Override
    public DoubleFV normaliseFV(double[] min, double[] max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min[i];
            int n2 = i;
            dvals[n2] = dvals[n2] / (max[i] - min[i]);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double min, double max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min;
            int n2 = i;
            dvals[n2] = dvals[n2] / (max - min);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV() {
        int i;
        double[] dvals = this.asDoubleVector();
        double sum = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            sum += dvals[i];
        }
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / sum;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double p) {
        int i;
        double[] dvals = this.asDoubleVector();
        double pnorm = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            pnorm += Math.pow(Math.abs(dvals[i]), p);
        }
        pnorm = Math.pow(pnorm, 1.0 / p);
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / pnorm;
        }
        return new DoubleFV(dvals);
    }

    public ShortFV clone() {
        try {
            ShortFV model = (ShortFV)super.clone();
            model.values = ((short[])this.values).clone();
            return model;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        String ret = this.getClass().getName() + Arrays.toString((short[])this.values);
        return ret;
    }

    @Override
    public DoubleFV asDoubleFV() {
        return new DoubleFV(this.asDoubleVector());
    }

    @Override
    public double[] asDoubleVector() {
        double[] d = new double[((short[])this.values).length];
        for (int i = 0; i < ((short[])this.values).length; ++i) {
            d[i] = ((short[])this.values)[i];
        }
        return d;
    }

    public double compare(ShortFV h, ShortFVComparison method) {
        return method.compare(this, h);
    }

    @Override
    public int length() {
        return ((short[])this.values).length;
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(((short[])this.values).length);
        for (int i = 0; i < ((short[])this.values).length; ++i) {
            out.writeShort(((short[])this.values)[i]);
        }
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.println(((short[])this.values).length);
        for (int i = 0; i < ((short[])this.values).length; ++i) {
            out.print(((short[])this.values)[i] + " ");
        }
        out.println();
    }

    public void readBinary(DataInput in) throws IOException {
        int nbins = in.readInt();
        this.values = new short[nbins];
        for (int i = 0; i < nbins; ++i) {
            ((short[])this.values)[i] = in.readShort();
        }
    }

    public void readASCII(Scanner in) throws IOException {
        int nbins = Integer.parseInt(in.nextLine());
        this.values = new short[nbins];
        String[] line = in.nextLine().trim().split(" ");
        for (int i = 0; i < nbins; ++i) {
            ((short[])this.values)[i] = Short.parseShort(line[i]);
        }
    }

    public byte[] binaryHeader() {
        return (this.getClass().getName().substring(0, 2) + "FV").getBytes();
    }

    public String asciiHeader() {
        return this.getClass().getName() + " ";
    }

    public ShortFV concatenate(ShortFV ... ins) {
        int l = ((short[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            l += ((short[])ins[i].values).length;
        }
        short[] data = new short[l];
        System.arraycopy(this.values, 0, data, 0, ((short[])this.values).length);
        int offset = ((short[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            System.arraycopy(ins[i].values, 0, data, offset, ((short[])ins[i].values).length);
            offset += ((short[])ins[i].values).length;
        }
        return new ShortFV(data);
    }

    public ShortFV concatenate(List<ShortFV> ins) {
        int l = ((short[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            l += ((short[])ins.get((int)i).values).length;
        }
        short[] data = new short[l];
        System.arraycopy(this.values, 0, data, 0, ((short[])this.values).length);
        int offset = ((short[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            System.arraycopy(ins.get((int)i).values, 0, data, offset, ((short[])ins.get((int)i).values).length);
            offset += ((short[])ins.get((int)i).values).length;
        }
        return new ShortFV(data);
    }

    public int hashCode() {
        return Arrays.hashCode((short[])this.values);
    }

    public boolean equals(Object obj) {
        return Arrays.equals((short[])this.values, (short[])((ShortFV)obj).values);
    }

    public ShortFV subvector(int beginIndex) {
        return new ShortFV(Arrays.copyOfRange((short[])this.values, beginIndex, ((short[])this.values).length));
    }

    public ShortFV subvector(int beginIndex, int endIndex) {
        return new ShortFV(Arrays.copyOfRange((short[])this.values, beginIndex, endIndex));
    }

    @Override
    public double getAsDouble(int i) {
        return ((short[])this.values)[i];
    }

    @Override
    public void setFromDouble(int i, double v) {
        ((short[])this.values)[i] = (short)v;
    }

    @Override
    public ShortFV newInstance() {
        return new ShortFV(this.length());
    }
}

