/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Scanner;
import org.openimaj.feature.FeatureVector;
import org.openimaj.feature.LongFV;
import org.openimaj.feature.LongFVComparison;
import org.openimaj.feature.MultidimensionalDoubleFV;

public class MultidimensionalLongFV
extends LongFV
implements Serializable,
Cloneable,
FeatureVector {
    private static final long serialVersionUID = 1L;
    public int[] nbins;

    public MultidimensionalLongFV() {
    }

    public MultidimensionalLongFV(int ... nbins) {
        if (nbins.length == 0) {
            throw new IllegalArgumentException("must be at least one dimension");
        }
        this.nbins = nbins;
        int sz = nbins[0];
        for (int i = 1; i < nbins.length; ++i) {
            sz *= nbins[i];
        }
        this.values = new long[sz];
    }

    public MultidimensionalLongFV(long[] values, int ... nbins) {
        if (nbins.length == 0) {
            throw new IllegalArgumentException("must be at least one dimension");
        }
        this.values = values;
        this.nbins = nbins;
    }

    public MultidimensionalLongFV(long[][] values) {
        this(values.length == 0 ? 0 : values[0].length, values.length);
        for (int j = 0; j < values.length; ++j) {
            for (int i = 0; i < values[0].length; ++i) {
                ((long[])this.values)[i + j * values[0].length] = values[j][i];
            }
        }
    }

    public MultidimensionalLongFV(long[][][] values) {
        this(values[0][0].length, values[0].length, values.length);
        for (int k = 0; k < values.length; ++k) {
            for (int j = 0; j < values[0].length; ++j) {
                for (int i = 0; i < values[0][0].length; ++i) {
                    ((long[])this.values)[i + j * values[0][0].length + k * values[0][0].length * values[0].length] = values[k][j][i];
                }
            }
        }
    }

    @Override
    public long[] getVector() {
        return (long[])this.values;
    }

    @Override
    public long get(int x) {
        return ((long[])this.values)[x];
    }

    @Override
    void set(long value, int x) {
        ((long[])this.values)[x] = value;
    }

    public int getIndex(int ... coords) {
        if (coords.length != this.nbins.length) {
            throw new IllegalArgumentException("given dimensions mismatch");
        }
        int idx = coords[0];
        for (int i = 1; i < coords.length; ++i) {
            int mult = this.nbins[0];
            for (int j = 1; j < i; ++j) {
                mult *= this.nbins[j];
            }
            idx += coords[i] * mult;
        }
        return idx;
    }

    public void set(long value, int ... coords) {
        ((long[])this.values)[this.getIndex((int[])coords)] = value;
    }

    public long get(int ... coords) {
        int idx = this.getIndex(coords);
        return ((long[])this.values)[idx];
    }

    @Override
    public MultidimensionalLongFV clone() {
        MultidimensionalLongFV model = (MultidimensionalLongFV)super.clone();
        model.nbins = (int[])this.nbins.clone();
        return model;
    }

    @Override
    public String toString() {
        String ret = this.getClass().getName();
        for (int dim : this.nbins) {
            ret = ret + "[" + dim + "]";
        }
        ret = ret + " {";
        if (this.nbins.length == 2) {
            ret = ret + "\n";
            for (int i = 0; i < this.nbins[1]; ++i) {
                for (int j = 0; j < this.nbins[0]; ++j) {
                    ret = ret + String.format("%2.4f", ((long[])this.values)[j + i * this.nbins[0]]);
                    ret = ret + ", ";
                }
                ret = ret + "\n";
            }
        } else {
            for (int i = 0; i < ((long[])this.values).length; ++i) {
                ret = ret + String.format("%2.3f", ((long[])this.values)[i]);
                if (i == ((long[])this.values).length - 1) continue;
                ret = ret + ", ";
            }
        }
        ret = ret + "}";
        return ret;
    }

    @Override
    public MultidimensionalDoubleFV asDoubleFV() {
        return new MultidimensionalDoubleFV(this.asDoubleVector(), (int[])this.nbins.clone());
    }

    public double compare(MultidimensionalLongFV h, LongFVComparison method) {
        return method.compare(this, h);
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        int i;
        out.writeInt(this.nbins.length);
        for (i = 0; i < this.nbins.length; ++i) {
            out.writeInt(this.nbins[i]);
        }
        for (i = 0; i < ((long[])this.values).length; ++i) {
            out.writeLong(((long[])this.values)[i]);
        }
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        int i;
        out.print(this.nbins.length + " ");
        for (i = 0; i < this.nbins.length; ++i) {
            out.print(this.nbins[i] + " ");
        }
        out.println();
        for (i = 0; i < ((long[])this.values).length; ++i) {
            out.print(((long[])this.values)[i] + " ");
        }
        out.println();
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        int i;
        int len = in.readInt();
        if (this.nbins == null || this.nbins.length != len) {
            this.nbins = new int[len];
        }
        for (int i2 = 0; i2 < len; ++i2) {
            this.nbins[i2] = in.readInt();
        }
        int sz = this.nbins[0];
        for (i = 1; i < this.nbins.length; ++i) {
            sz *= this.nbins[i];
        }
        this.values = new long[sz];
        for (i = 0; i < sz; ++i) {
            ((long[])this.values)[i] = in.readLong();
        }
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        int i;
        String[] line = in.nextLine().trim().split(" ");
        int len = Integer.parseInt(line[0]);
        if (this.nbins == null || this.nbins.length != len) {
            this.nbins = new int[len];
        }
        for (int i2 = 0; i2 < len; ++i2) {
            this.nbins[i2] = Integer.parseInt(line[i2 + 1]);
        }
        int sz = this.nbins[0];
        for (i = 1; i < this.nbins.length; ++i) {
            sz *= this.nbins[i];
        }
        this.values = new long[sz];
        line = in.nextLine().trim().split(" ");
        for (i = 0; i < sz; ++i) {
            ((long[])this.values)[i] = Long.parseLong(line[i]);
        }
    }

    @Override
    public byte[] binaryHeader() {
        return (this.getClass().getName().substring(0, 2) + "MDFV").getBytes();
    }

    @Override
    public String asciiHeader() {
        return this.getClass().getName() + " ";
    }

    public int[] getCoordinates(int index) {
        int ndims = this.nbins.length;
        int[] start = new int[ndims];
        float multiply = 1.0f;
        for (int i : this.nbins) {
            multiply *= (float)i;
        }
        if ((float)index >= multiply) {
            throw new IllegalArgumentException();
        }
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = ndims - 1; i >= 0; --i) {
            int numberOfSlices;
            start[i] = numberOfSlices = (int)Math.floor((float)index / (multiply /= (float)this.nbins[i]));
            index = (int)((float)index - (float)numberOfSlices * multiply);
        }
        return start;
    }
}

