/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.feature.FeatureExtractor;

public class DatasetExtractors {
    private DatasetExtractors() {
    }

    public static <FEATURE, OBJECT> ListDataset<FEATURE> createLazyFeatureDataset(final ListDataset<OBJECT> input, final FeatureExtractor<FEATURE, OBJECT> extractor) {
        return new ListBackedDataset((List)new AbstractList<FEATURE>(){

            @Override
            public FEATURE get(int index) {
                return extractor.extractFeature(input.get(index));
            }

            @Override
            public int size() {
                return input.size();
            }
        });
    }

    public static <FEATURE, OBJECT, KEY> GroupedDataset<KEY, ListDataset<FEATURE>, FEATURE> createLazyFeatureDataset(final GroupedDataset<KEY, ? extends ListDataset<OBJECT>, OBJECT> input, final FeatureExtractor<FEATURE, OBJECT> extractor) {
        return new MapBackedDataset((Map)new AbstractMap<KEY, ListDataset<FEATURE>>(){

            @Override
            public int size() {
                return input.size();
            }

            @Override
            public boolean isEmpty() {
                return input.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return input.containsKey(key);
            }

            @Override
            public ListDataset<FEATURE> get(Object key) {
                return DatasetExtractors.createLazyFeatureDataset((ListDataset)input.get(key), extractor);
            }

            @Override
            public Set<KEY> keySet() {
                return input.keySet();
            }

            @Override
            public Set<Map.Entry<KEY, ListDataset<FEATURE>>> entrySet() {
                return new AbstractSet<Map.Entry<KEY, ListDataset<FEATURE>>>(){

                    @Override
                    public Iterator<Map.Entry<KEY, ListDataset<FEATURE>>> iterator() {
                        return new Iterator<Map.Entry<KEY, ListDataset<FEATURE>>>(){
                            Iterator<?> internal;
                            {
                                this.internal = input.entrySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.internal.hasNext();
                            }

                            @Override
                            public Map.Entry<KEY, ListDataset<FEATURE>> next() {
                                return new Map.Entry<KEY, ListDataset<FEATURE>>(){
                                    Map.Entry<KEY, OBJECT> next;
                                    {
                                        this.next = (Map.Entry)internal.next();
                                    }

                                    @Override
                                    public KEY getKey() {
                                        return this.next.getKey();
                                    }

                                    @Override
                                    public ListDataset<FEATURE> getValue() {
                                        return DatasetExtractors.createLazyFeatureDataset((ListDataset)this.next.getValue(), extractor);
                                    }

                                    @Override
                                    public ListDataset<FEATURE> setValue(ListDataset<FEATURE> value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return input.size();
                    }
                };
            }
        });
    }
}

