/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.hog;

import de.bwaldvogel.liblinear.SolverType;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.data.RandomData;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.feature.DatasetExtractors;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.feature.IdentityFeatureExtractor;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.analysis.algorithm.histogram.binning.SpatialBinningStrategy;
import org.openimaj.image.feature.dense.gradient.HOG;
import org.openimaj.image.feature.dense.gradient.binning.FlexibleHOGStrategy;
import org.openimaj.image.objectdetection.datasets.INRIAPersonDataset;
import org.openimaj.image.objectdetection.hog.HOGClassifier;
import org.openimaj.image.objectdetection.hog.HOGDetector;
import org.openimaj.image.processing.convolution.FImageGradients;
import org.openimaj.io.IOUtils;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.statistics.distribution.Histogram;
import org.openimaj.ml.annotation.linear.LiblinearAnnotator;
import org.openimaj.util.list.AcceptingListView;
import org.openimaj.util.list.ConcatenatedList;
import org.openimaj.util.pair.IntObjectPair;

public class Training {
    public static void main(String[] args) throws IOException {
        HOGClassifier hogClassifier = new HOGClassifier();
        hogClassifier.width = 64;
        hogClassifier.height = 128;
        FlexibleHOGStrategy strategy = new FlexibleHOGStrategy(8, 16, 2);
        hogClassifier.hogExtractor = new HOG(9, false, FImageGradients.Mode.Unsigned, (SpatialBinningStrategy)strategy);
        GroupedDataset<Boolean, ListDataset<FImage>, FImage> trainingImages = INRIAPersonDataset.getTrainingData();
        GroupedDataset trainingData = DatasetExtractors.createLazyFeatureDataset(trainingImages, (FeatureExtractor)new Extractor(hogClassifier));
        LiblinearAnnotator ann = new LiblinearAnnotator((FeatureExtractor)new IdentityFeatureExtractor(), LiblinearAnnotator.Mode.MULTICLASS, SolverType.L2R_L2LOSS_SVC, 0.01, 0.01, 1.0, true);
        ann.train(trainingData);
        hogClassifier.classifier = ann;
        IOUtils.writeToFile((Object)hogClassifier, (File)new File("initial-classifier.dat"));
        HOGDetector detector = new HOGDetector(hogClassifier, 1.2f);
        final ListDataset negImages = INRIAPersonDataset.getNegativeTrainingImages(ImageUtilities.FIMAGE_READER);
        final ArrayList<IntObjectPair> extraNegatives = new ArrayList<IntObjectPair>();
        for (int i = 0; i < negImages.numInstances(); ++i) {
            FImage image = (FImage)negImages.get(i);
            List<Rectangle> rects = detector.detect(image);
            if (rects == null) continue;
            for (Rectangle r : rects) {
                extraNegatives.add(new IntObjectPair(i, (Object)r));
            }
        }
        AbstractList<FImage> hardExamples = new AbstractList<FImage>(){
            int lastImageId = -1;
            FImage lastImage;

            @Override
            public FImage get(int index) {
                IntObjectPair p = (IntObjectPair)extraNegatives.get(index);
                if (p.first != this.lastImageId) {
                    this.lastImageId = p.first;
                    this.lastImage = (FImage)negImages.get(p.first);
                }
                return (FImage)this.lastImage.extractROI((Rectangle)p.second);
            }

            @Override
            public int size() {
                return extraNegatives.size();
            }
        };
        int[] indices = RandomData.getUniqueRandomInts((int)2000, (int)0, (int)hardExamples.size());
        Arrays.sort(indices);
        hardExamples = new AcceptingListView((List)hardExamples, indices);
        ConcatenatedList extendedNegatives = new ConcatenatedList((List)trainingImages.get((Object)false), (List)hardExamples);
        MapBackedDataset extendedTrainingImages = new MapBackedDataset();
        extendedTrainingImages.put((Object)true, trainingImages.get((Object)true));
        extendedTrainingImages.put((Object)false, (Object)new ListBackedDataset((List)extendedNegatives));
        GroupedDataset extendedTrainingData = DatasetExtractors.createLazyFeatureDataset((GroupedDataset)extendedTrainingImages, (FeatureExtractor)new Extractor(hogClassifier));
        ann = new LiblinearAnnotator((FeatureExtractor)new IdentityFeatureExtractor(), LiblinearAnnotator.Mode.MULTICLASS, SolverType.L2R_L2LOSS_SVC, 0.01, 0.01, 1.0, true);
        ann.train(extendedTrainingData);
        hogClassifier.classifier = ann;
        int c = 0;
        int p = 0;
        for (FImage i : INRIAPersonDataset.getPositiveTrainingImages(ImageUtilities.FIMAGE_READER)) {
            hogClassifier.prepare(i);
            int offsetX = (i.width - 64) / 2;
            int offsetY = (i.height - 128) / 2;
            p += hogClassifier.classify(new Rectangle((float)offsetX, (float)offsetY, 64.0f, 128.0f)) > 0.5 ? 1 : 0;
            ++c;
        }
        System.out.println(p + "/" + c);
        IOUtils.writeToFile((Object)hogClassifier, (File)new File("final-classifier.dat"));
    }

    static class Extractor
    implements FeatureExtractor<DoubleFV, FImage> {
        HOGClassifier hogClassifier;

        Extractor(HOGClassifier hogClassifier) {
            this.hogClassifier = hogClassifier;
        }

        public DoubleFV extractFeature(FImage image) {
            int offsetX = (image.width - 64) / 2;
            int offsetY = (image.height - 128) / 2;
            this.hogClassifier.hogExtractor.analyseImage(image);
            Histogram f = this.hogClassifier.hogExtractor.getFeatureVector(new Rectangle((float)offsetX, (float)offsetY, 64.0f, 128.0f));
            return f;
        }
    }
}

