/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.haar;

import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.openimaj.image.analysis.algorithm.SummedSqTiltAreaTable;
import org.openimaj.image.objectdetection.haar.Detector;
import org.openimaj.image.objectdetection.haar.StageTreeClassifier;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.function.Operation;
import org.openimaj.util.parallel.GlobalExecutorPool;
import org.openimaj.util.parallel.Parallel;

public class MultiThreadedDetector
extends Detector {
    private ThreadPoolExecutor threadPool;

    public MultiThreadedDetector(StageTreeClassifier cascade, float scaleFactor, int smallStep, int bigStep, ThreadPoolExecutor threadPool) {
        super(cascade, scaleFactor, smallStep, bigStep);
        if (threadPool == null) {
            threadPool = GlobalExecutorPool.getPool();
        }
        this.threadPool = threadPool;
    }

    public MultiThreadedDetector(StageTreeClassifier cascade, float scaleFactor) {
        this(cascade, scaleFactor, 1, 2, null);
    }

    public MultiThreadedDetector(StageTreeClassifier cascade) {
        this(cascade, 1.1f, 1, 2, null);
    }

    @Override
    protected void detectAtScale(final SummedSqTiltAreaTable sat, final int startX, final int stopX, int startY, int stopY, final float ystep, final int windowWidth, final int windowHeight, final List<Rectangle> results) {
        Parallel.forRange((int)startY, (int)stopY, (int)1, (Operation)new Operation<Parallel.IntRange>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(Parallel.IntRange range) {
                for (int iy = range.start; iy < range.stop; iy += range.incr) {
                    int y = Math.round((float)iy * ystep);
                    int xstep = 0;
                    for (int ix = startX; ix < stopX; ix += xstep) {
                        int x = Math.round((float)ix * ystep);
                        int result = MultiThreadedDetector.this.cascade.classify(sat, x, y);
                        if (result > 0) {
                            List list = results;
                            synchronized (list) {
                                results.add(new Rectangle((float)x, (float)y, (float)windowWidth, (float)windowHeight));
                            }
                        }
                        xstep = result == 0 ? MultiThreadedDetector.this.smallStep : MultiThreadedDetector.this.bigStep;
                    }
                }
            }
        }, (ThreadPoolExecutor)this.threadPool);
    }
}

