/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection;

import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.image.objectdetection.ObjectDetector;
import org.openimaj.image.objectdetection.filtering.DetectionFilter;
import org.openimaj.math.geometry.shape.Rectangle;

public class FilteringObjectDetector<IMAGE extends Image<?, IMAGE>, DETECTED_OBJECT, FILTERED_OBJECT>
implements ObjectDetector<IMAGE, FILTERED_OBJECT> {
    private ObjectDetector<IMAGE, DETECTED_OBJECT> detector;
    private DetectionFilter<DETECTED_OBJECT, FILTERED_OBJECT> filter;

    public FilteringObjectDetector(ObjectDetector<IMAGE, DETECTED_OBJECT> detector, DetectionFilter<DETECTED_OBJECT, FILTERED_OBJECT> filter) {
        this.detector = detector;
        this.filter = filter;
    }

    @Override
    public List<FILTERED_OBJECT> detect(IMAGE image) {
        return this.filter.apply(this.detector.detect(image));
    }

    @Override
    public void setROI(Rectangle roi) {
        this.detector.setROI(roi);
    }
}

