/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.pgm.vb.lda.mle;

import org.openimaj.pgm.util.Document;
import org.openimaj.pgm.vb.lda.mle.LDAModel;
import org.openimaj.util.array.SparseIntArray;

public class LDAVariationlState {
    public double[][] phi;
    public double[] oldphi;
    public double[] varGamma;
    public double likelihood;
    public double oldLikelihood;
    public LDAModel state;
    public double[] digamma;
    int iteration;

    public LDAVariationlState(LDAModel state) {
        this.oldphi = new double[state.ntopics];
        this.varGamma = new double[state.ntopics];
        this.digamma = new double[state.ntopics];
        this.state = state;
    }

    public void prepare(Document doc) {
        this.phi = new double[doc.countUniqueWords()][this.state.ntopics];
        this.likelihood = 0.0;
        this.oldLikelihood = Double.NEGATIVE_INFINITY;
        for (int topici = 0; topici < this.phi.length; ++topici) {
            this.varGamma[topici] = this.state.alpha;
            this.digamma[topici] = 0.0;
            int wordi = 0;
            for (SparseIntArray.Entry wordCount : doc.getVector().entries()) {
                this.phi[wordi][topici] = 1.0f / (float)this.state.ntopics;
                int n = topici;
                this.varGamma[n] = this.varGamma[n] + (double)wordCount.value / (double)this.state.ntopics;
                ++wordi;
            }
        }
        this.iteration = 0;
    }
}

