/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.series;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Scanner;
import org.openimaj.io.ReadWriteableASCII;
import org.openimaj.ml.timeseries.TimeSeries;
import org.openimaj.ml.timeseries.TimeSeriesArithmaticOperator;
import org.openimaj.ml.timeseries.collection.TimeSeriesCollectionAssignable;
import org.openimaj.ml.timeseries.series.DoubleTimeSeriesProvider;
import org.openimaj.util.pair.IndependentPair;

public class DoubleTimeSeries
extends TimeSeries<double[], Double, DoubleTimeSeries>
implements TimeSeriesArithmaticOperator<Double, DoubleTimeSeries>,
ReadWriteableASCII,
TimeSeriesCollectionAssignable<Double, DoubleTimeSeries>,
DoubleTimeSeriesProvider {
    private long[] times;
    private double[] data;
    int size = 0;

    public DoubleTimeSeries(int i) {
        this.times = new long[i];
        this.data = new double[i];
        this.size = i;
    }

    public DoubleTimeSeries() {
        this.times = new long[0];
        this.data = new double[0];
        this.size = 0;
    }

    public DoubleTimeSeries(long[] times, double[] data) {
        this.times = times;
        this.data = data;
        this.size = this.data.length;
    }

    private int[] findStartEnd(long time, int nbefore, int nafter) {
        int index = Arrays.binarySearch(this.times, time);
        int fixed = index < 0 ? -1 * (index + 1) : index;
        int start = 0;
        int end = this.times.length - 1;
        start = fixed - nbefore;
        end = index < 0 ? fixed + nafter : fixed + nafter + 1;
        if (start < 0) {
            start = 0;
        }
        if (end > this.times.length) {
            end = this.times.length;
        }
        return new int[]{start, end};
    }

    @Override
    public DoubleTimeSeries get(long time, int nbefore, int nafter) {
        if (nbefore < 0 || nafter < 0) {
            return new DoubleTimeSeries();
        }
        int[] startend = this.findStartEnd(time, nbefore, nafter);
        double[] dataoutput = new double[startend[1] - startend[0]];
        System.arraycopy(this.data, startend[0], dataoutput, 0, dataoutput.length);
        long[] timeoutput = new long[startend[1] - startend[0]];
        System.arraycopy(this.times, startend[0], timeoutput, 0, timeoutput.length);
        DoubleTimeSeries output = this.newInstance(timeoutput, dataoutput);
        return output;
    }

    @Override
    public DoubleTimeSeries get(long time, int nbefore, int nafter, DoubleTimeSeries output) {
        int[] startend = this.findStartEnd(time, nbefore, nafter);
        System.arraycopy(this.data, startend[0], output.data, 0, startend[1] - startend[0]);
        System.arraycopy(this.times, startend[0], output.times, 0, startend[1] - startend[0]);
        output.size = startend[1] - startend[0];
        return output;
    }

    @Override
    public DoubleTimeSeries get(long time, long threshbefore, long threshafter) {
        int start;
        if (threshafter < 0L || threshbefore < 0L) {
            return new DoubleTimeSeries();
        }
        int[] startend = this.findStartEnd(time, 0, 0);
        int end = start = startend[0];
        while (start > 0 && this.times[start - 1] >= time - threshbefore) {
            --start;
        }
        while (end < this.times.length && this.times[end] <= time + threshafter) {
            ++end;
        }
        double[] dataoutput = new double[end - start];
        System.arraycopy(this.data, start, dataoutput, 0, dataoutput.length);
        long[] timeoutput = new long[end - start];
        System.arraycopy(this.times, start, timeoutput, 0, timeoutput.length);
        DoubleTimeSeries output = this.newInstance(timeoutput, dataoutput);
        return output;
    }

    @Override
    public DoubleTimeSeries get(long start, long end) {
        return this.get(start, 0L, end - start);
    }

    private DoubleTimeSeries newInstance(long[] timeoutput, double[] dataoutput) {
        DoubleTimeSeries output = this.newInstance();
        output.set(timeoutput, dataoutput);
        return output;
    }

    @Override
    public void set(long[] times, double[] data) {
        this.times = times;
        this.data = data;
        this.size = data.length;
    }

    @Override
    public long[] getTimes() {
        return this.times;
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public DoubleTimeSeries newInstance() {
        return new DoubleTimeSeries();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void internalAssign(DoubleTimeSeries interpolate) {
        this.data = Arrays.copyOf(interpolate.data, interpolate.data.length);
        this.times = Arrays.copyOf(interpolate.times, interpolate.times.length);
        this.size = interpolate.size();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lf = "%d => %.5f\n";
        for (int i = 0; i < this.size(); ++i) {
            long time = this.times[i];
            double data = this.data[i];
            sb.append(String.format(lf, time, data));
        }
        return sb.toString();
    }

    @Override
    public Iterator<IndependentPair<Long, Double>> iterator() {
        return new Iterator<IndependentPair<Long, Double>>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DoubleTimeSeries.this.size;
            }

            @Override
            public IndependentPair<Long, Double> next() {
                IndependentPair toret = IndependentPair.pair((Object)DoubleTimeSeries.this.times[this.index], (Object)DoubleTimeSeries.this.data[this.index]);
                ++this.index;
                return toret;
            }

            @Override
            public void remove() {
            }
        };
    }

    public void readASCII(Scanner in) throws IOException {
        this.size = in.nextInt();
        this.data = new double[this.size];
        this.times = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.times[i] = in.nextLong();
            this.data[i] = in.nextDouble();
        }
    }

    public String asciiHeader() {
        return "";
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.print(this.size() + " ");
        for (IndependentPair<Long, Double> timedouble : this) {
            out.print(timedouble.firstObject() + " " + timedouble.secondObject() + " ");
        }
    }

    @Override
    public DoubleTimeSeries newInstance(Collection<Long> time, Collection<Double> data) {
        DoubleTimeSeries d = new DoubleTimeSeries();
        d.internalAssign(time, data);
        return d;
    }

    @Override
    public void internalAssign(Collection<Long> time, Collection<Double> data) {
        this.times = new long[time.size()];
        this.data = new double[time.size()];
        this.size = data.size();
        int i = 0;
        for (Long l : time) {
            this.times[i++] = l;
        }
        i = 0;
        for (Double d : data) {
            this.data[i++] = d;
        }
    }

    @Override
    public void internalAssign(long[] times, double[] data) {
        this.times = times;
        this.data = data;
        this.size = times.length;
    }

    @Override
    public Double zero() {
        return 0.0;
    }

    @Override
    public Double sum() {
        double s = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            s += this.data[i];
        }
        return s;
    }

    @Override
    public DoubleTimeSeries doubleTimeSeries() {
        return this;
    }
}

