/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.processor.interpolation;

import org.openimaj.ml.timeseries.processor.TimeSeriesProcessor;
import org.openimaj.ml.timeseries.processor.interpolation.util.TimeSpanUtils;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;

public abstract class TimeSeriesInterpolation
implements TimeSeriesProcessor<double[], Double, DoubleTimeSeries> {
    private long[] times;

    public TimeSeriesInterpolation() {
        this.times = null;
    }

    public TimeSeriesInterpolation(long begin, long end, long delta) {
        this.times = TimeSpanUtils.getTime(begin, end, delta);
    }

    public TimeSeriesInterpolation(long begin, int steps, long delta) {
        this.times = TimeSpanUtils.getTime(begin, steps, delta);
    }

    public TimeSeriesInterpolation(long begin, long end, int steps) {
        this.times = TimeSpanUtils.getTime(begin, end, steps);
    }

    public TimeSeriesInterpolation(long[] times) {
        this.times = times;
    }

    public DoubleTimeSeries interpolate(DoubleTimeSeries series, long begin, long end, long delta) {
        long[] times = TimeSpanUtils.getTime(begin, end, delta);
        return this.interpolate(series, times);
    }

    public DoubleTimeSeries interpolate(DoubleTimeSeries series, long begin, int steps, long delta) {
        long[] times = TimeSpanUtils.getTime(begin, steps, delta);
        return this.interpolate(series, times);
    }

    public DoubleTimeSeries interpolate(DoubleTimeSeries series, long begin, long end, int splits) {
        long[] times = TimeSpanUtils.getTime(begin, end, splits);
        return this.interpolate(series, times);
    }

    public DoubleTimeSeries interpolate(DoubleTimeSeries series) {
        return this.interpolate(series, this.times);
    }

    public abstract DoubleTimeSeries interpolate(DoubleTimeSeries var1, long[] var2);

    @Override
    public void process(DoubleTimeSeries ts) {
        ts.internalAssign(this.interpolate(ts, this.times));
    }
}

