/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.regression;

import java.util.Arrays;
import java.util.List;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SVD;
import org.openimaj.math.matrix.MatrixUtils;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.util.pair.IndependentPair;

public class LinearRegression
implements EstimatableModel<double[], double[]> {
    private Jama.Matrix weights;

    public boolean estimate(List<? extends IndependentPair<double[], double[]>> data) {
        if (data.size() == 0) {
            return false;
        }
        int correctedx = ((double[])data.get(0).firstObject()).length + 1;
        int correctedy = ((double[])data.get(0).secondObject()).length;
        double[][] y = new double[data.size()][correctedy];
        double[][] x = new double[data.size()][correctedx];
        int i = 0;
        for (IndependentPair<double[], double[]> independentPair : data) {
            y[i] = (double[])independentPair.secondObject();
            x[i][0] = 1.0;
            System.arraycopy(independentPair.firstObject(), 0, x[i], 1, ((double[])independentPair.firstObject()).length);
            ++i;
        }
        this.estimate_internal(new Jama.Matrix(y), new Jama.Matrix(x));
        return true;
    }

    public void estimate(double[][] yd, double[][] xd) {
        double[][] x = this.appendConstant(xd);
        this.estimate_internal(new Jama.Matrix(yd), new Jama.Matrix(x));
    }

    private double[][] appendConstant(double[][] xd) {
        int corrected = xd[0].length + 1;
        double[][] x = new double[xd.length][corrected];
        for (int i = 0; i < xd.length; ++i) {
            x[i][0] = 1.0;
            System.arraycopy(xd[i], 0, x[i], 1, xd[i].length);
        }
        return x;
    }

    public void estimate(Jama.Matrix y, Jama.Matrix x) {
        this.estimate(y.getArray(), x.getArray());
    }

    private void estimate_internal(Jama.Matrix y, Jama.Matrix x) {
        try {
            DenseMatrix mjtX = new DenseMatrix(x.getArray());
            SVD svd = SVD.factorize((Matrix)mjtX);
            Jama.Matrix u = MatrixUtils.convert((DenseMatrix)svd.getU(), (int)svd.getU().numRows(), (int)svd.getS().length);
            Jama.Matrix v = MatrixUtils.convert((DenseMatrix)svd.getVt(), (int)svd.getS().length, (int)svd.getVt().numColumns()).transpose();
            Jama.Matrix d = MatrixUtils.diag((double[])svd.getS());
            this.weights = v.times(MatrixUtils.pseudoInverse((Jama.Matrix)d)).times(u.transpose()).times(y);
        }
        catch (NotConvergedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public double[] predict(double[] data) {
        double[][] corrected = new double[][]{new double[data.length + 1]};
        corrected[0][0] = 1.0;
        System.arraycopy(data, 0, corrected[0], 1, data.length);
        Jama.Matrix x = new Jama.Matrix((double[][])corrected);
        return x.times(this.weights).transpose().getArray()[0];
    }

    public Jama.Matrix predict(Jama.Matrix x) {
        x = new Jama.Matrix(this.appendConstant(x.getArray()));
        return x.times(this.weights);
    }

    public int numItemsToEstimate() {
        return 2;
    }

    public LinearRegression clone() {
        return new LinearRegression();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LinearRegression)) {
            return false;
        }
        LinearRegression that = (LinearRegression)obj;
        double[][] thatw = that.weights.getArray();
        double[][] thisw = this.weights.getArray();
        for (int i = 0; i < thisw.length; ++i) {
            if (Arrays.equals(thatw[i], thisw[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "LinearRegression with coefficients: " + Arrays.toString(this.weights.transpose().getArray()[0]);
    }
}

