/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.regul;

import gov.sandia.cognition.math.matrix.Matrix;
import org.openimaj.ml.linear.learner.regul.Regulariser;

public class L1Regulariser
implements Regulariser {
    @Override
    public Matrix prox(Matrix W, double lambda) {
        return this.softThreshold(W, lambda);
    }

    private Matrix softThreshold(Matrix w, double lambda) {
        Matrix ret = w.clone();
        ret.zero();
        int nrow = w.getNumRows();
        int ncol = w.getNumColumns();
        for (int r = 0; r < nrow; ++r) {
            for (int c = 0; c < ncol; ++c) {
                double v = ret.getElement(r, c);
                if (v < -lambda) {
                    ret.setElement(r, c, v + lambda);
                    continue;
                }
                if (!(v > lambda)) continue;
                ret.setElement(r, c, v - lambda);
            }
        }
        return ret;
    }
}

