/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.regul;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseRowMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseVector;
import org.openimaj.math.matrix.CFMatrixUtils;
import org.openimaj.ml.linear.learner.regul.Regulariser;

public class L1L2Regulariser
implements Regulariser {
    @Override
    public Matrix prox(Matrix W, double lambda) {
        int nrows = W.getNumRows();
        SparseMatrix ret = SparseMatrixFactoryMTJ.INSTANCE.createMatrix(W.getNumRows(), W.getNumColumns());
        SparseRowMatrix Wrow = CFMatrixUtils.asSparseRow((Matrix)W);
        ret = CFMatrixUtils.asSparseRow((Matrix)ret);
        for (int r = 0; r < nrows; ++r) {
            SparseVector row = Wrow.getRow(r);
            double rownorm = row.norm2();
            if (!(rownorm > lambda)) continue;
            double scal = (rownorm - lambda) / rownorm;
            Vector scaled = (Vector)row.scale(scal);
            ret.setRow(r, scaled);
        }
        return CFMatrixUtils.asSparseColumn((Matrix)ret);
    }
}

