/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.perceptron;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.math.matrix.MeanVector;
import org.openimaj.ml.linear.kernel.VectorKernel;
import org.openimaj.ml.linear.learner.perceptron.DoubleArrayKernelPerceptron;
import org.openimaj.ml.linear.learner.perceptron.PerceptronClass;

public class MeanCenteredKernelPerceptron
extends DoubleArrayKernelPerceptron {
    MeanVector mv = new MeanVector();

    public MeanCenteredKernelPerceptron(VectorKernel k) {
        super(k);
    }

    @Override
    public void update(double[] xt, PerceptronClass yt, PerceptronClass yt_prime) {
        this.mv.update(xt);
        super.update(xt, yt, yt_prime);
    }

    @Override
    public double[] correct(double[] in) {
        return this.center(in);
    }

    @Override
    public List<double[]> getSupports() {
        List<double[]> pre = super.getSupports();
        ArrayList<double[]> ret = new ArrayList<double[]>();
        for (double[] ds : pre) {
            ret.add(this.correct(ds));
        }
        return ret;
    }

    private double[] center(double[] xt) {
        double[] mvec = this.mv.vec();
        double[] ret = new double[xt.length];
        if (mvec == null) {
            return ret;
        }
        for (int i = 0; i < mvec.length; ++i) {
            ret[i] = xt[i] - mvec[i];
        }
        return ret;
    }

    public double[] getMean() {
        return this.mv.vec();
    }
}

