/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.data;

import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import gov.sandia.cognition.math.matrix.Matrix;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openimaj.math.matrix.CFMatrixUtils;
import org.openimaj.ml.linear.data.MatrixDataGenerator;
import org.openimaj.util.pair.Pair;

public class MatlabFileDataGenerator
implements MatrixDataGenerator<Matrix> {
    private MLCell data;
    private int index;

    public MatlabFileDataGenerator(File matfile) throws IOException {
        MatFileReader reader = new MatFileReader(matfile);
        Map content = reader.getContent();
        this.data = (MLCell)content.get("XYs");
        this.index = 0;
    }

    @Override
    public Pair<Matrix> generate() {
        if (this.index >= this.data.getM()) {
            return null;
        }
        Pair XY = new Pair((Object)CFMatrixUtils.asMat((MLArray)this.data.get(this.index, 0)), (Object)CFMatrixUtils.asMat((MLArray)this.data.get(this.index, 1)));
        ++this.index;
        return XY;
    }

    public int size() {
        return this.data.getM();
    }
}

