/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation.basic;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.knn.ObjectNearestNeighbours;
import org.openimaj.knn.ObjectNearestNeighboursExact;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.IncrementalAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.util.comparator.DistanceComparator;

public class KNNAnnotator<OBJECT, ANNOTATION, FEATURE>
extends IncrementalAnnotator<OBJECT, ANNOTATION> {
    protected int k = 1;
    protected final List<FEATURE> features = new ArrayList<FEATURE>();
    protected final List<Collection<ANNOTATION>> annotations = new ArrayList<Collection<ANNOTATION>>();
    protected final Set<ANNOTATION> annotationsSet = new HashSet<ANNOTATION>();
    protected ObjectNearestNeighbours<FEATURE> nn;
    protected DistanceComparator<? super FEATURE> comparator;
    protected final float threshold;
    protected FeatureExtractor<FEATURE, OBJECT> extractor;

    public KNNAnnotator(FeatureExtractor<FEATURE, OBJECT> extractor, DistanceComparator<? super FEATURE> comparator, float threshold) {
        this(extractor, comparator, 1, threshold);
    }

    public KNNAnnotator(FeatureExtractor<FEATURE, OBJECT> extractor, DistanceComparator<? super FEATURE> comparator) {
        this(extractor, comparator, 1, Float.MAX_VALUE);
    }

    public KNNAnnotator(FeatureExtractor<FEATURE, OBJECT> extractor, DistanceComparator<? super FEATURE> comparator, int k) {
        this(extractor, comparator, k, Float.MAX_VALUE);
    }

    public KNNAnnotator(FeatureExtractor<FEATURE, OBJECT> extractor, DistanceComparator<? super FEATURE> comparator, int k, float threshold) {
        this.extractor = extractor;
        this.comparator = comparator;
        this.k = k;
        this.threshold = comparator.isDistance() ? threshold : -threshold;
    }

    public static <OBJECT, ANNOTATION, EXTRACTOR extends FeatureExtractor<FEATURE, OBJECT>, FEATURE> KNNAnnotator<OBJECT, ANNOTATION, FEATURE> create(EXTRACTOR extractor, DistanceComparator<FEATURE> comparator, float threshold) {
        return new KNNAnnotator<OBJECT, ANNOTATION, FEATURE>(extractor, comparator, threshold);
    }

    public static <OBJECT, ANNOTATION, EXTRACTOR extends FeatureExtractor<FEATURE, OBJECT>, FEATURE> KNNAnnotator<OBJECT, ANNOTATION, FEATURE> create(EXTRACTOR extractor, DistanceComparator<FEATURE> comparator) {
        return new KNNAnnotator<OBJECT, ANNOTATION, FEATURE>(extractor, comparator);
    }

    public static <OBJECT, ANNOTATION, EXTRACTOR extends FeatureExtractor<FEATURE, OBJECT>, FEATURE> KNNAnnotator<OBJECT, ANNOTATION, FEATURE> create(EXTRACTOR extractor, DistanceComparator<FEATURE> comparator, int k) {
        return new KNNAnnotator<OBJECT, ANNOTATION, FEATURE>(extractor, comparator, k);
    }

    public static <OBJECT, ANNOTATION, EXTRACTOR extends FeatureExtractor<FEATURE, OBJECT>, FEATURE> KNNAnnotator<OBJECT, ANNOTATION, FEATURE> create(EXTRACTOR extractor, DistanceComparator<FEATURE> comparator, int k, float threshold) {
        return new KNNAnnotator<OBJECT, ANNOTATION, FEATURE>(extractor, comparator, k, threshold);
    }

    @Override
    public void train(Annotated<OBJECT, ANNOTATION> annotated) {
        this.nn = null;
        this.features.add(this.extractor.extractFeature(annotated.getObject()));
        Collection<ANNOTATION> anns = annotated.getAnnotations();
        this.annotations.add(anns);
        this.annotationsSet.addAll(anns);
    }

    @Override
    public void reset() {
        this.nn = null;
        this.features.clear();
        this.annotations.clear();
        this.annotationsSet.clear();
    }

    @Override
    public Set<ANNOTATION> getAnnotations() {
        return this.annotationsSet;
    }

    @Override
    public List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT object) {
        if (this.nn == null) {
            this.nn = new ObjectNearestNeighboursExact(this.features, this.comparator);
        }
        TObjectIntHashMap selected = new TObjectIntHashMap();
        ArrayList<Object> queryfv = new ArrayList<Object>(1);
        queryfv.add(this.extractor.extractFeature(object));
        int[][] indices = new int[1][this.k];
        float[][] distances = new float[1][this.k];
        this.nn.searchKNN(queryfv, this.k, indices, (Object[])distances);
        int count = 0;
        for (int i = 0; i < this.k; ++i) {
            if (distances[0][i] > this.threshold) continue;
            Collection<ANNOTATION> anns = this.annotations.get(indices[0][i]);
            for (ANNOTATION ann : anns) {
                selected.adjustOrPutValue(ann, 1, 1);
                ++count;
            }
        }
        TObjectIntIterator iterator = selected.iterator();
        ArrayList<ScoredAnnotation<ANNOTATION>> result = new ArrayList<ScoredAnnotation<ANNOTATION>>(selected.size());
        while (iterator.hasNext()) {
            iterator.advance();
            result.add(new ScoredAnnotation<Object>(iterator.key(), (float)iterator.value() / (float)count));
        }
        return result;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }
}

