/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.web.scraping.images;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openimaj.io.HttpUtils;
import org.openimaj.web.scraping.SiteSpecificConsumer;

public class YfrogConsumer
implements SiteSpecificConsumer {
    @Override
    public boolean canConsume(URL url) {
        return url.getHost().contains("yfrog");
    }

    @Override
    public List<URL> consume(URL url) {
        try {
            byte[] retPage = HttpUtils.readURLAsBytes((URL)url, (boolean)false);
            Document soup = Jsoup.parse((String)new String(retPage, "UTF-8"));
            Elements imageElement = soup.select(".the-image img");
            ArrayList<URL> ret = new ArrayList<URL>();
            for (Element element : imageElement) {
                String imageSource = element.attr("src");
                if (imageSource == null) continue;
                URL link = new URL(imageSource);
                ret.add(link);
            }
            return ret;
        }
        catch (Throwable e) {
            return null;
        }
    }
}

