/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.web.scraping.images;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openimaj.web.scraping.SiteSpecificConsumer;

public class InstagramConsumer
implements SiteSpecificConsumer {
    String apiCallFormat = "http://api.instagram.com/oembed?url=http://instagr.am/p/%s";
    private transient Gson gson = new Gson();

    @Override
    public boolean canConsume(URL url) {
        return url.getHost().equals("instagr.am") || url.getHost().equals("instagram.com");
    }

    @Override
    public List<URL> consume(URL url) {
        String file = url.getFile();
        if (file.endsWith("/")) {
            file = file.substring(0, file.length() - 1);
        }
        String[] splits = file.split("/");
        String shortID = splits[splits.length - 1];
        String apiCall = String.format(this.apiCallFormat, shortID);
        try {
            Map res = (Map)this.gson.fromJson((Reader)new InputStreamReader(new URL(apiCall).openConnection().getInputStream()), Map.class);
            String instagramURL = (String)res.get("url");
            URL u = new URL(instagramURL);
            return Arrays.asList(u);
        }
        catch (Exception e) {
            return null;
        }
    }
}

