/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.web.scraping.images;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.web.scraping.SiteSpecificConsumer;
import org.openimaj.web.scraping.images.ImgurClient;

public class ImgurConsumer
implements SiteSpecificConsumer {
    private ImgurClient client = new ImgurClient();

    @Override
    public boolean canConsume(URL url) {
        return url.getHost().contains("imgur");
    }

    @Override
    public List<URL> consume(URL url) {
        try {
            List<ImgurClient.ImageResponse> imageJSON = null;
            ArrayList<URL> ret = new ArrayList<URL>();
            imageJSON = this.client.getImages(ImgurClient.imgurURLtoHash(url));
            for (ImgurClient.ImageResponse imageResponse : imageJSON) {
                URL link = imageResponse.getOriginalLink();
                ret.add(link);
            }
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }
}

