/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.web.scraping.images;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openimaj.io.HttpUtils;
import org.openimaj.web.scraping.SiteSpecificConsumer;

public class FacebookConsumer
implements SiteSpecificConsumer {
    @Override
    public boolean canConsume(URL url) {
        return url.getHost().contains("facebook");
    }

    @Override
    public List<URL> consume(URL url) {
        String urlFile = url.getFile();
        List<URL> ret = null;
        if (urlFile.startsWith("/photo.php")) {
            ret = this.consumeFacebookPhoto(url);
        } else if (urlFile.contains("/posts/")) {
            ret = this.consumeFacebookPost(url);
        }
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    private List<URL> consumeFacebookPost(URL url) {
        try {
            byte[] retPage = HttpUtils.readURLAsBytes((URL)url, (boolean)false);
            Document soup = Jsoup.parse((String)new String(retPage, "UTF-8"));
            Elements imageElement = soup.select(".storyInnerContent img");
            ArrayList<URL> ret = new ArrayList<URL>();
            for (Element element : imageElement) {
                String imageSource = element.attr("src");
                if (imageSource == null) continue;
                URL u = new URL(imageSource);
                ret.add(u);
            }
            return ret;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private List<URL> consumeFacebookPhoto(URL url) {
        try {
            byte[] retPage = HttpUtils.readURLAsBytes((URL)url, (boolean)false);
            Document soup = Jsoup.parse((String)new String(retPage, "UTF-8"));
            Elements imageElement = soup.select("#fbPhotoImage");
            ArrayList<URL> ret = new ArrayList<URL>();
            for (Element element : imageElement) {
                String imageSource = element.attr("src");
                if (imageSource == null) continue;
                URL u = new URL(imageSource);
                ret.add(u);
            }
            return ret;
        }
        catch (Throwable e) {
            return null;
        }
    }
}

