/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.web.scraping;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openimaj.io.HttpUtils;
import org.openimaj.web.scraping.SiteSpecificConsumer;

public abstract class HTMLScrapingSiteSpecificConsumer
implements SiteSpecificConsumer {
    @Override
    public List<URL> consume(URL url) {
        try {
            ByteArrayInputStream stream = (ByteArrayInputStream)HttpUtils.readURLAsByteArrayInputStream((URL)url, (int)1000, (int)1000, null, (String)"Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)").getSecondObject();
            byte[] retPage = IOUtils.toByteArray((InputStream)stream);
            Document soup = Jsoup.parse((String)new String(retPage, "UTF-8"));
            Elements imageElement = soup.select(this.cssSelect());
            ArrayList<URL> ret = new ArrayList<URL>();
            for (Element element : imageElement) {
                String imageSource = element.attr("src");
                if (imageSource == null) continue;
                try {
                    URL link = new URL(imageSource);
                    ret.add(link);
                }
                catch (Throwable e) {
                    URL link = new URL(url.getProtocol(), url.getHost(), imageSource);
                    ret.add(link);
                }
            }
            return ret;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public abstract String cssSelect();
}

