/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

public class UrlUtilities {
    public static final String UTF8 = "UTF-8";

    @Deprecated
    public static URL buildUrl(String host, int port, String path, Map<String, String> parameters) throws MalformedURLException {
        return UrlUtilities.buildUrl("http", port, path, parameters);
    }

    public static URL buildUrl(String scheme, String host, int port, String path, Map<String, String> parameters) throws MalformedURLException {
        UrlUtilities.checkSchemeAndPort(scheme, port);
        StringBuilder buffer = new StringBuilder();
        if (!host.startsWith(scheme + "://")) {
            buffer.append(scheme).append("://");
        }
        buffer.append(host);
        if (port > 0) {
            buffer.append(':');
            buffer.append(port);
        }
        if (path == null) {
            path = "/";
        }
        buffer.append(path);
        if (!parameters.isEmpty()) {
            buffer.append('?');
        }
        int size = parameters.size();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            buffer.append(entry.getKey());
            buffer.append('=');
            String value = entry.getValue();
            if (value != null) {
                String string = value.toString();
                try {
                    string = URLEncoder.encode(string, UTF8);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                buffer.append(string);
            }
            if (--size == 0) continue;
            buffer.append('&');
        }
        return new URL(buffer.toString());
    }

    public static URL buildSecureUrl(String host, int port, String path, Map<String, String> parameters) throws MalformedURLException {
        return UrlUtilities.buildUrl("https", host, port, path, parameters);
    }

    public static URL buildSecurePostUrl(String host, int port, String path) throws MalformedURLException {
        return UrlUtilities.buildPostUrl("https", host, port, path);
    }

    private static void checkScheme(String scheme) {
        if (scheme == null || !"http".equals(scheme) && !"https".equals(scheme)) {
            throw new IllegalArgumentException("scheme must be http or https");
        }
    }

    private static void checkSchemeAndPort(String scheme, int port) {
        UrlUtilities.checkScheme(scheme);
        if ("http".equals(scheme) && port == 443) {
            throw new IllegalArgumentException("port 443 is invalid with http scheme");
        }
        if ("https".equals(scheme) && port == 80) {
            throw new IllegalArgumentException("port 80 is invalid with https scheme");
        }
    }

    public static URL buildPostUrl(String host, int port, String path) throws MalformedURLException {
        return UrlUtilities.buildPostUrl("http", host, port, path);
    }

    public static URL buildPostUrl(String scheme, String host, int port, String path) throws MalformedURLException {
        UrlUtilities.checkSchemeAndPort(scheme, port);
        StringBuilder buffer = new StringBuilder();
        buffer.append(scheme).append("://");
        buffer.append(host);
        if (port > 0) {
            buffer.append(':');
            buffer.append(port);
        }
        if (path == null) {
            path = "/";
        }
        buffer.append(path);
        return new URL(buffer.toString());
    }

    @Deprecated
    public static String createBuddyIconUrl(int iconFarm, int iconServer, String id) {
        return UrlUtilities.createBuddyIconUrl("http", iconFarm, iconServer, id);
    }

    public static String createSecureBuddyIconUrl(int iconFarm, int iconServer, String id) {
        return UrlUtilities.createBuddyIconUrl("https", iconFarm, iconServer, id);
    }

    public static String createBuddyIconUrl(String scheme, int iconFarm, int iconServer, String id) {
        UrlUtilities.checkScheme(scheme);
        String iconUrl = scheme + "://www.flickr.com/images/buddyicon.jpg";
        if (iconServer > 0) {
            iconUrl = scheme + "://farm" + iconFarm + ".static.flickr.com/" + iconServer + "/buddyicons/" + id + ".jpg";
        }
        return iconUrl;
    }
}

