/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.photos.upload;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.photos.upload.Ticket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UploadInterface {
    public static final String METHOD_CHECK_TICKETS = "flickr.photos.upload.checkTickets";
    private String apiKey;
    private String sharedSecret;
    private Transport transportAPI;

    public UploadInterface(String apiKey, String sharedSecret, Transport transport) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transport;
    }

    public List<Ticket> checkTickets(Set<String> tickets) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_CHECK_TICKETS);
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = tickets.iterator();
        while (it.hasNext()) {
            String obj;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if ((obj = it.next()) instanceof Ticket) {
                sb.append(((Ticket)((Object)obj)).getTicketId());
                continue;
            }
            sb.append((Object)obj);
        }
        parameters.put("tickets", sb.toString());
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        ArrayList<Ticket> list = new ArrayList<Ticket>();
        Element uploaderElement = response.getPayload();
        NodeList ticketNodes = uploaderElement.getElementsByTagName("ticket");
        int n = ticketNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Element ticketElement = (Element)ticketNodes.item(i);
            String id = ticketElement.getAttribute("id");
            String complete = ticketElement.getAttribute("complete");
            boolean invalid = "1".equals(ticketElement.getAttribute("invalid"));
            String photoId = ticketElement.getAttribute("photoid");
            Ticket info = new Ticket();
            info.setTicketId(id);
            info.setInvalid(invalid);
            info.setStatus(Integer.parseInt(complete));
            info.setPhotoId(photoId);
            list.add(info);
        }
        return list;
    }
}

