/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.photos.notes;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.photos.Note;
import java.awt.Rectangle;
import java.util.HashMap;
import org.w3c.dom.Element;

public class NotesInterface {
    public static final String METHOD_ADD = "flickr.photos.notes.add";
    public static final String METHOD_DELETE = "flickr.photos.notes.delete";
    public static final String METHOD_EDIT = "flickr.photos.notes.edit";
    private String apiKey;
    private String sharedSecret;
    private Transport transportAPI;

    public NotesInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public Note add(String photoId, Note note) throws FlickrException {
        Response response;
        String text;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_ADD);
        parameters.put("photo_id", photoId);
        Rectangle bounds = note.getBounds();
        if (bounds != null) {
            parameters.put("note_x", String.valueOf(bounds.x));
            parameters.put("note_y", String.valueOf(bounds.y));
            parameters.put("note_w", String.valueOf(bounds.width));
            parameters.put("note_h", String.valueOf(bounds.height));
        }
        if ((text = note.getText()) != null) {
            parameters.put("note_text", text);
        }
        if ((response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element noteElement = response.getPayload();
        note.setId(noteElement.getAttribute("id"));
        return note;
    }

    public void delete(String noteId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_DELETE);
        parameters.put("note_id", noteId);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void edit(Note note) throws FlickrException {
        Response response;
        String text;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_EDIT);
        parameters.put("note_id", note.getId());
        Rectangle bounds = note.getBounds();
        if (bounds != null) {
            parameters.put("note_x", String.valueOf(bounds.x));
            parameters.put("note_y", String.valueOf(bounds.y));
            parameters.put("note_w", String.valueOf(bounds.width));
            parameters.put("note_h", String.valueOf(bounds.height));
        }
        if ((text = note.getText()) != null) {
            parameters.put("note_text", text);
        }
        if ((response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }
}

