/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.sql;

import com.hp.hpl.jena.sdb.sql.RS;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBConnectionHolder;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TableUtils {
    public static void dump(SDBConnection conn, String tableName) {
        ResultSetJDBC tableData = null;
        try {
            tableData = conn.execQuery("SELECT * FROM " + tableName);
            RS.printResultSet(tableData.get());
            tableData.close();
        }
        catch (SQLException ex) {
            try {
                throw new SDBExceptionSQL(ex);
            }
            catch (Throwable throwable) {
                RS.close(tableData);
                throw throwable;
            }
        }
        RS.close(tableData);
    }

    public static void dump(Connection conn, String tableName) {
        try {
            Statement s = conn.createStatement();
            ResultSet tableData = s.executeQuery("SELECT * FROM " + tableName);
            RS.printResultSet(tableData);
            tableData.close();
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }

    public static boolean hasTable(Connection connection, String table, String ... types) throws SQLException {
        if (types.length == 0) {
            types = null;
        }
        ResultSet tableData = connection.getMetaData().getTables(null, null, table, types);
        boolean hasTable = tableData.next();
        tableData.close();
        if (!hasTable) {
            tableData = connection.getMetaData().getTables(null, null, table.toLowerCase(), types);
            hasTable = tableData.next();
            tableData.close();
        }
        if (!hasTable) {
            tableData = connection.getMetaData().getTables(null, null, table.toUpperCase(), types);
            hasTable = tableData.next();
            tableData.close();
        }
        return hasTable;
    }

    public static boolean hasTable(SDBConnectionHolder holder, String table, String ... types) throws SQLException {
        return TableUtils.hasTable(holder.connection().getSqlConnection(), table, types);
    }

    public static List<String> getTableNames(Connection connection) {
        return TableUtils.getTableNames(connection, "TABLE");
    }

    public static List<String> getTableNames(Connection connection, String tableTypeName) {
        try {
            ArrayList<String> tableNames = new ArrayList<String>();
            ResultSet rs = connection.getMetaData().getTables(null, null, null, new String[]{tableTypeName});
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                tableNames.add(tableName);
            }
            return tableNames;
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }

    public static long getTableSize(Connection connection, String table) {
        long size = -1L;
        try {
            ResultSet res = connection.createStatement().executeQuery("SELECT COUNT(*) FROM " + table);
            if (res.next()) {
                size = res.getLong(1);
            }
            res.close();
        }
        catch (SQLException e) {
            throw new SDBExceptionSQL(e);
        }
        return size;
    }

    public static void dropTable(SDBConnection connection, String tableName) {
        try {
            if (TableUtils.hasTable(connection.getSqlConnection(), tableName, new String[0])) {
                connection.execSilent("DROP TABLE " + tableName);
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException : Can't drop table: " + tableName, ex);
        }
    }

    public static void dropTableSilent(SDBConnection connection, String tableName) {
        connection.execSilent("DROP TABLE " + tableName);
    }
}

