/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.sdb.layout2.index.TupleLoaderIndexBase;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.TableDesc;

public class TupleLoaderIndexMySQL
extends TupleLoaderIndexBase {
    public TupleLoaderIndexMySQL(SDBConnection connection, TableDesc tableDesc, int chunkSize) {
        super(connection, tableDesc, chunkSize);
    }

    @Override
    public String[] getNodeColTypes() {
        return new String[]{"BIGINT", "LONGTEXT BINARY CHARACTER SET utf8", "VARCHAR(10) BINARY CHARACTER SET utf8", "VARCHAR(200) BINARY CHARACTER SET utf8", "INT"};
    }

    @Override
    public String getTupleColType() {
        return "BIGINT";
    }

    @Override
    public String[] getCreateTempTable() {
        return new String[]{"CREATE TEMPORARY TABLE", "ENGINE=MYISAM"};
    }

    @Override
    public String getLoadNodes() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT IGNORE INTO Nodes (hash, lex, lang, datatype, type) \nSELECT ");
        for (int i = 0; i < this.getNodeColTypes().length; ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append("n").append(i);
        }
        stmt.append("\nFROM ").append(this.getNodeLoader());
        return stmt.toString();
    }

    @Override
    public String getLoadTuples() {
        int i;
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT IGNORE INTO ").append(this.getTableName()).append(" \nSELECT ");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append("NI").append(i).append(".id");
        }
        stmt.append("\nFROM ").append(this.getTupleLoader()).append(" ");
        for (i = 0; i < this.getTableWidth(); ++i) {
            stmt.append("JOIN Nodes AS NI").append(i).append(" ON (");
            stmt.append(this.getTupleLoader()).append(".t").append(i).append("=NI").append(i).append(".hash)\n");
        }
        return stmt.toString();
    }

    @Override
    public String getDeleteTuples() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("DELETE FROM ").append(this.getTableName()).append(" \nWHERE\n");
        for (int i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" AND\n");
            }
            stmt.append(this.getTableDesc().getColNames().get(i)).append(" = (SELECT id FROM Nodes WHERE hash = ?) ");
        }
        return stmt.toString();
    }

    @Override
    public String getDeleteAllTuples() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("DELETE FROM ").append(this.getTableName());
        if (this.getTableWidth() != 3) {
            stmt.append(" \nWHERE\n");
            stmt.append(this.getTableDesc().getColNames().get(0));
            stmt.append(" = (SELECT id FROM Nodes WHERE hash = ?) ");
        }
        return stmt.toString();
    }
}

