/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.sdb.layout2.FmtLayout2;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.TablePrefixes;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.SQLException;

public class FmtLayout2IndexDB2
extends FmtLayout2 {
    public FmtLayout2IndexDB2(SDBConnection connection) {
        super(connection);
    }

    @Override
    protected void formatTableTriples() {
        this.dropTable(TableDescTriples.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescTriples.name() + " (", "    s INT NOT NULL,", "    p INT NOT NULL,", "    o INT NOT NULL,", "    PRIMARY KEY (s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableQuads() {
        this.dropTable(TableDescQuads.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescQuads.name() + " (", "    g INT NOT NULL,", "    s INT NOT NULL,", "    p INT NOT NULL,", "    o INT NOT NULL,", "    PRIMARY KEY (g, s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescNodes.name() + " (", "   id INT NOT NULL ,", "   hash BIGINT NOT NULL,", "   lex CLOB NOT NULL,", "   lang VARCHAR(10),", "   datatype VARCHAR(200),", "   type INTEGER  NOT NULL,", "   PRIMARY KEY (id)", ")  CCSID UNICODE"));
            this.connection().execSilent("DROP SEQUENCE nodeid");
            this.connection().exec(SQLUtils.sqlStr("CREATE SEQUENCE nodeid AS INT", "START WITH 1", "INCREMENT BY 1", "CACHE 5000", "ORDER", "NO MAXVALUE", "NO CYCLE"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TableDescNodes.name() + "'", ex);
        }
    }

    @Override
    protected void formatTablePrefixes() {
        this.dropTable(TablePrefixes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TablePrefixes.name() + " (", "    prefix VARCHAR(50) NOT NULL,", "    uri VARCHAR(500) ,", "    PRIMARY KEY  (prefix)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TablePrefixes.name() + "'", ex);
        }
    }

    @Override
    protected void truncateTable(String tableName) {
        try {
            this.connection().exec("DELETE FROM " + tableName);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException truncating table: " + tableName, ex);
        }
    }
}

