/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.hash;

import com.hp.hpl.jena.sdb.layout2.hash.TupleLoaderHashBase;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleLoaderHashOracle
extends TupleLoaderHashBase {
    private static Logger log = LoggerFactory.getLogger(TupleLoaderHashOracle.class);

    public TupleLoaderHashOracle(SDBConnection connection, TableDesc tableDesc, int chunkSize) {
        super(connection, tableDesc, chunkSize);
    }

    @Override
    public String[] getNodeColTypes() {
        return new String[]{"NUMBER(20)", "NCLOB", "NVARCHAR2(10)", "NVARCHAR2(200)", "INT"};
    }

    @Override
    public String getTupleColType() {
        return "NUMBER(20)";
    }

    @Override
    public String[] getCreateTempTable() {
        return new String[]{"CREATE GLOBAL TEMPORARY TABLE", "ON COMMIT DELETE ROWS"};
    }

    @Override
    public boolean clearsOnCommit() {
        return true;
    }

    @Override
    public String getLoadNodes() {
        return "BEGIN LOCK TABLE Nodes IN EXCLUSIVE MODE;\n" + super.getLoadNodes() + ";\nEND;";
    }
}

