/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.compiler.QueryCompilerFactory;
import com.hp.hpl.jena.sdb.core.sqlnode.GenerateSQL;
import com.hp.hpl.jena.sdb.layout1.TupleLoaderSimple;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBConnectionHolder;
import com.hp.hpl.jena.sdb.sql.TableUtils;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.sdb.store.SQLBridgeFactory;
import com.hp.hpl.jena.sdb.store.SQLGenerator;
import com.hp.hpl.jena.sdb.store.StoreConfig;
import com.hp.hpl.jena.sdb.store.StoreFormatter;
import com.hp.hpl.jena.sdb.store.StoreLoader;
import com.hp.hpl.jena.sdb.store.TupleGraphLoader;

public class StoreBase1
extends SDBConnectionHolder
implements Store {
    protected StoreDesc storeDescription;
    protected StoreFormatter formatter;
    protected StoreLoader loader;
    protected QueryCompilerFactory compilerF;
    protected SQLBridgeFactory sqlBridgeF;
    protected SQLGenerator sqlGenerator;
    protected StoreConfig configuration;
    protected TableDescTriples tripleTable;
    protected boolean isClosed = false;

    public StoreBase1(SDBConnection connection, StoreDesc desc, StoreFormatter formatter, TupleLoaderSimple loader, QueryCompilerFactory compilerF, SQLBridgeFactory sqlBridgeF, SQLGenerator sqlGenerator, TableDescTriples tripleTable) {
        super(connection);
        this.storeDescription = desc;
        this.formatter = formatter;
        if (loader.getTableDesc() == null) {
            loader.setTableDesc(tripleTable);
        }
        this.loader = new TupleGraphLoader(loader);
        this.compilerF = compilerF;
        this.sqlBridgeF = sqlBridgeF;
        if (sqlGenerator == null) {
            sqlGenerator = new GenerateSQL();
        }
        this.sqlGenerator = sqlGenerator;
        this.tripleTable = tripleTable;
        this.configuration = new StoreConfig(this.connection());
    }

    @Override
    public SDBConnection getConnection() {
        return this.connection();
    }

    @Override
    public QueryCompilerFactory getQueryCompilerFactory() {
        return this.compilerF;
    }

    @Override
    public SQLBridgeFactory getSQLBridgeFactory() {
        return this.sqlBridgeF;
    }

    @Override
    public SQLGenerator getSQLGenerator() {
        return this.sqlGenerator;
    }

    @Override
    public StoreFormatter getTableFormatter() {
        return this.formatter;
    }

    @Override
    public StoreLoader getLoader() {
        return this.loader;
    }

    @Override
    public StoreConfig getConfiguration() {
        return this.configuration;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.storeDescription.getDbType();
    }

    @Override
    public LayoutType getLayoutType() {
        return this.storeDescription.getLayout();
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public long getSize() {
        return TableUtils.getTableSize(this.getConnection().getSqlConnection(), "Triples");
    }

    @Override
    public long getSize(Node node) {
        return this.getSize();
    }

    @Override
    public TableDescNodes getNodeTableDesc() {
        return null;
    }

    @Override
    public TableDescTriples getTripleTableDesc() {
        return this.tripleTable;
    }

    @Override
    public TableDescQuads getQuadTableDesc() {
        return null;
    }
}

